/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.network;

import com.teamtea.eclipticseasons.client.color.season.BiomeColorsHandler;
import com.teamtea.eclipticseasons.client.core.ClientWeatherChecker;
import com.teamtea.eclipticseasons.client.render.WorldRenderer;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.SnowyRemover;
import com.teamtea.eclipticseasons.common.network.message.BiomeWeatherMessage;
import com.teamtea.eclipticseasons.common.network.message.ChunkBiomeUpdateMessage;
import com.teamtea.eclipticseasons.common.network.message.ChunkUpdateMessage;
import com.teamtea.eclipticseasons.common.network.message.ConfigMessage;
import com.teamtea.eclipticseasons.common.network.message.EmptyMessage;
import com.teamtea.eclipticseasons.common.network.message.HumidModifyMessage;
import com.teamtea.eclipticseasons.common.network.message.SolarTermsMessage;
import com.teamtea.eclipticseasons.common.network.message.UpdateTempChangeMessage;
import com.teamtea.eclipticseasons.common.registry.AttachmentRegistry;
import com.teamtea.eclipticseasons.config.ClientConfig;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class NetworkUtil {
    public static void processSolarTermsMessage2(SolarTermsMessage solarTermsMessage, IPayloadContext context) {
        context.enqueueWork(() -> SolarHolders.getSaveDataLazy(context.player().level()).ifPresent(data -> {
            data.setSolarTermsDay(solarTermsMessage.solarDay);
            BiomeColorsHandler.needRefresh = true;
            ClientCon.tick(context.player().level());
            BiomeColorsHandler.reloadColors();
        })).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"eclipticseasons.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void processEmptyMessage(EmptyMessage emptyMessage, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (((Boolean)ClientConfig.Renderer.resetRendererAfterSleep.get()).booleanValue()) {
                Minecraft.getInstance().levelRenderer.allChanged();
            } else {
                Entity patt0$temp = Minecraft.getInstance().cameraEntity;
                if (patt0$temp instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)patt0$temp;
                    WorldRenderer.setAllDirty(SectionPos.of((BlockPos)livingEntity.getOnPos()));
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"eclipticseasons.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void processBiomeWeatherMessage(BiomeWeatherMessage biomeWeatherMessage, IPayloadContext context) {
        context.enqueueWork(() -> {
            ArrayList<WeatherManager.BiomeWeather> lists = WeatherManager.getBiomeList(context.player().level());
            if (lists != null) {
                boolean update = false;
                for (WeatherManager.BiomeWeather biomeWeather : lists) {
                    if (biomeWeatherMessage.rain[biomeWeather.id] == 0 && biomeWeather.rainTime > 0) {
                        ClientWeatherChecker.addLastRainyBiome((Biome)biomeWeather.biomeHolder.value(), (long)(1.0f / ClientWeatherChecker.getRate()));
                    }
                    if (!update && biomeWeather.rainTime + biomeWeather.clearTime + biomeWeather.thunderTime > 0) {
                        update = biomeWeather.snowDepth == biomeWeatherMessage.snowDepth[biomeWeather.id];
                    }
                    biomeWeather.rainTime = biomeWeatherMessage.rain[biomeWeather.id] * 10000;
                    biomeWeather.clearTime = biomeWeatherMessage.clear[biomeWeather.id] * 10000;
                    biomeWeather.thunderTime = biomeWeatherMessage.thuder[biomeWeather.id] * 10000;
                    biomeWeather.snowDepth = biomeWeatherMessage.snowDepth[biomeWeather.id];
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"eclipticseasons.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void processChunkUpdateMessage(ChunkUpdateMessage chunkUpdateMessage, IPayloadContext context) {
        int[][] blocks = new int[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                blocks[i][j] = chunkUpdateMessage.snowyArea[i * 16 + j];
            }
        }
        context.enqueueWork(() -> {
            LevelChunk patt1$temp;
            Level level;
            Level patt0$temp = context.player().level();
            if (patt0$temp instanceof Level && (level = patt0$temp).isClientSide() && (patt1$temp = level.getChunk(chunkUpdateMessage.x, chunkUpdateMessage.z)) instanceof LevelChunk) {
                LevelChunk levelChunk = patt1$temp;
                SnowyRemover snow = new SnowyRemover(blocks);
                levelChunk.setData(AttachmentRegistry.SNOWY_REMOVER, (Object)new SnowyRemover(blocks));
                List<Integer> y = chunkUpdateMessage.y;
                if (y.size() == 1) {
                    y = new ArrayList<Integer>(y);
                    y.add(y.getFirst() - 1);
                }
                for (Integer ySection : y) {
                    WorldRenderer.setSectionDirty(SectionPos.of((int)chunkUpdateMessage.x, (int)ySection, (int)chunkUpdateMessage.z));
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"eclipticseasons.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void handleConfigMessage(ConfigMessage configMessage, IPayloadContext iPayloadContext) {
        iPayloadContext.enqueueWork(() -> CommonConfig.Season.validDimensions.set(configMessage.SeasonalDimensions().stream().map(k -> k.location().toString()).toList()));
    }

    public static void processChunkBiomeUpdateMessage(ChunkBiomeUpdateMessage chunkBiomeUpdateMessage, IPayloadContext iPayloadContext) {
        iPayloadContext.enqueueWork(() -> {
            ChunkAccess chunk;
            if (ClientCon.getUseLevel() != null && (chunk = ClientCon.getUseLevel().getChunk(chunkBiomeUpdateMessage.x, chunkBiomeUpdateMessage.z, ChunkStatus.FULL, false)) != null) {
                chunk.setData(AttachmentRegistry.BIOME_HOLDER, (Object)new BiomeHolder(chunkBiomeUpdateMessage.biomes, true, chunkBiomeUpdateMessage.version));
            }
        });
    }

    public static void processHumidModifyMessage(HumidModifyMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Level level;
            Level patt0$temp = context.player().level();
            if (patt0$temp instanceof Level && (level = patt0$temp).isClientSide()) {
                ClientCon.humidityModificationLevel = message.value;
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"eclipticseasons.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public static void processUpdateTempChangeMessage(UpdateTempChangeMessage emptyMessage, IPayloadContext context) {
        context.enqueueWork(() -> {
            Level patt0$temp = context.player().level();
            if (patt0$temp instanceof Level) {
                Level level = patt0$temp;
                SolarHolders.getSaveDataLazy(level).ifPresent(solarDataManager -> solarDataManager.setSolarTempChange(emptyMessage.change));
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"eclipticseasons.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

