/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.network;

import com.teamtea.eclipticseasons.common.network.ESConfigTask;
import com.teamtea.eclipticseasons.common.network.NetworkUtil;
import com.teamtea.eclipticseasons.common.network.message.BiomeWeatherMessage;
import com.teamtea.eclipticseasons.common.network.message.ChunkBiomeUpdateMessage;
import com.teamtea.eclipticseasons.common.network.message.ChunkUpdateMessage;
import com.teamtea.eclipticseasons.common.network.message.ConfigMessage;
import com.teamtea.eclipticseasons.common.network.message.EmptyMessage;
import com.teamtea.eclipticseasons.common.network.message.HumidModifyMessage;
import com.teamtea.eclipticseasons.common.network.message.SolarTermsMessage;
import com.teamtea.eclipticseasons.common.network.message.UpdateTempChangeMessage;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="eclipticseasons", bus=EventBusSubscriber.Bus.MOD)
public final class SimpleNetworkHandler {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1.0");
        registrar.configurationToClient(ConfigMessage.TYPE, ConfigMessage.STREAM_CODEC, NetworkUtil::handleConfigMessage);
        registrar.playToClient(SolarTermsMessage.TYPE, SolarTermsMessage.STREAM_CODEC, NetworkUtil::processSolarTermsMessage2);
        registrar.playToClient(EmptyMessage.TYPE, EmptyMessage.STREAM_CODEC, NetworkUtil::processEmptyMessage);
        registrar.playToClient(BiomeWeatherMessage.TYPE, BiomeWeatherMessage.STREAM_CODEC, NetworkUtil::processBiomeWeatherMessage);
        registrar.playToClient(ChunkUpdateMessage.TYPE, ChunkUpdateMessage.STREAM_CODEC, NetworkUtil::processChunkUpdateMessage);
        registrar.playToClient(ChunkBiomeUpdateMessage.TYPE, ChunkBiomeUpdateMessage.STREAM_CODEC, NetworkUtil::processChunkBiomeUpdateMessage);
        registrar.playToClient(HumidModifyMessage.TYPE, HumidModifyMessage.STREAM_CODEC, NetworkUtil::processHumidModifyMessage);
        registrar.playToClient(UpdateTempChangeMessage.TYPE, UpdateTempChangeMessage.STREAM_CODEC, NetworkUtil::processUpdateTempChangeMessage);
    }

    @SubscribeEvent
    public static void onRegisterConfigurationTasksEvent(RegisterConfigurationTasksEvent event) {
        event.register((ConfigurationTask)new ESConfigTask(event));
    }

    public static <MSG extends CustomPacketPayload> void send(ServerPlayer player, MSG msg) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <MSG extends CustomPacketPayload> void send(List<ServerPlayer> players, MSG msg) {
        players.forEach(player -> SimpleNetworkHandler.send(player, msg));
    }
}

