/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.network.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MessageCodec {
    public static final StreamCodec<ByteBuf, List<Integer>> intlistStreamCodec = new StreamCodec<ByteBuf, List<Integer>>(){

        public void encode(ByteBuf pBuffer, List<Integer> pValue) {
            pBuffer.writeInt(pValue.size());
            for (Integer i : pValue) {
                pBuffer.writeInt(i.intValue());
            }
        }

        @NotNull
        public List<Integer> decode(ByteBuf pBuffer) {
            int size = pBuffer.readInt();
            ArrayList<Integer> list = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                list.add(pBuffer.readInt());
            }
            return list;
        }
    };
    public static final StreamCodec<ByteBuf, List<BlockPos>> poslistStreamCodec = new StreamCodec<ByteBuf, List<BlockPos>>(){

        public void encode(ByteBuf pBuffer, List<BlockPos> pValue) {
            pBuffer.writeInt(pValue.size());
            for (BlockPos i : pValue) {
                BlockPos.STREAM_CODEC.encode((Object)pBuffer, (Object)i);
            }
        }

        @NotNull
        public List<BlockPos> decode(ByteBuf pBuffer) {
            int size = pBuffer.readInt();
            ArrayList<BlockPos> list = new ArrayList<BlockPos>(size);
            for (int i = 0; i < size; ++i) {
                list.add((BlockPos)BlockPos.STREAM_CODEC.decode((Object)pBuffer));
            }
            return list;
        }
    };
    public static final StreamCodec<ByteBuf, List<ResourceKey<Level>>> dimensionKeysStreamCodec = new StreamCodec<ByteBuf, List<ResourceKey<Level>>>(){

        public void encode(ByteBuf pBuffer, List<ResourceKey<Level>> pValue) {
            pBuffer.writeInt(pValue.size());
            for (ResourceKey<Level> i : pValue) {
                ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION).encode((Object)pBuffer, i);
            }
        }

        @NotNull
        public List<ResourceKey<Level>> decode(ByteBuf pBuffer) {
            int size = pBuffer.readInt();
            ArrayList<ResourceKey<Level>> list = new ArrayList<ResourceKey<Level>>(size);
            for (int i = 0; i < size; ++i) {
                list.add((ResourceKey<Level>)((ResourceKey)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION).decode((Object)pBuffer)));
            }
            return list;
        }
    };
    public static final StreamCodec<ByteBuf, int[]> intArrayStreamCodec = new StreamCodec<ByteBuf, int[]>(){

        public void encode(ByteBuf pBuffer, int[] pValue) {
            pBuffer.writeInt(pValue.length);
            for (int i : pValue) {
                ByteBufCodecs.VAR_INT.encode((Object)pBuffer, (Object)i);
            }
        }

        public int @NotNull [] decode(ByteBuf pBuffer) {
            int size = pBuffer.readInt();
            int[] list = new int[size];
            for (int i = 0; i < size; ++i) {
                list[i] = (Integer)ByteBufCodecs.VAR_INT.decode((Object)pBuffer);
            }
            return list;
        }
    };
}

