/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.climate.TemperateRain;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.misc.SolarTermValueMap;
import com.teamtea.eclipticseasons.api.data.weather.CustomRainBuilder;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class BiomeRainRegistry {
    public static final ResourceKey<CustomRainBuilder> PLAIN = BiomeRainRegistry.createKey("plain");

    private static ResourceKey<CustomRainBuilder> createKey(String name) {
        return ResourceKey.create(ESRegistries.BIOME_RAIN, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static void bootstrap2(BootstrapContext<CustomRainBuilder> context) {
        HolderGetter holderGetter = context.lookup(Registries.BIOME);
        SolarTermValueMap<List<CustomRainBuilder.Weather>> solarTermValueMap = SolarTermValueMap.builder().solarTermMap(new Enum2ObjectMap(SolarTerm.class)).build();
        for (int i = 0; i < TemperateRain.collectValues().length; ++i) {
            TemperateRain temperateRain = TemperateRain.collectValues()[i];
            SolarTerm solarTerm = temperateRain.getSolarTerm();
            boolean isSpring = solarTerm == SolarTerm.SPRING_EQUINOX;
            solarTermValueMap.solarTermMap().get().put(solarTerm, List.of(new CustomRainBuilder.Weather(isSpring ? Optional.of(ServerLevel.RAIN_DURATION) : Optional.empty(), isSpring ? Optional.of(ServerLevel.RAIN_DELAY) : Optional.empty(), isSpring ? Optional.of(ServerLevel.THUNDER_DURATION) : Optional.empty(), temperateRain.getRainChance(), temperateRain.getThunderChance(), List.of())));
        }
        context.register(PLAIN, (Object)new CustomRainBuilder((HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{holderGetter.getOrThrow(Biomes.PLAINS)}), solarTermValueMap));
    }
}

