/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.google.common.collect.ImmutableMap;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.crop.CropHumidityType;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonType;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.CropClimateTags;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.crop.CropGrowControlBuilder;
import com.teamtea.eclipticseasons.api.data.crop.GrowParameter;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.common.registry.AgroClimateRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class CropRegistry {
    public static final ResourceKey<CropGrowControlBuilder> SPRING = CropRegistry.createKey(CropSeasonType.SPRING);
    public static final ResourceKey<CropGrowControlBuilder> SUMMER = CropRegistry.createKey(CropSeasonType.SUMMER);
    public static final ResourceKey<CropGrowControlBuilder> AUTUMN = CropRegistry.createKey(CropSeasonType.AUTUMN);
    public static final ResourceKey<CropGrowControlBuilder> WINTER = CropRegistry.createKey(CropSeasonType.WINTER);
    public static final ResourceKey<CropGrowControlBuilder> SP_SU = CropRegistry.createKey(CropSeasonType.SP_SU);
    public static final ResourceKey<CropGrowControlBuilder> SP_AU = CropRegistry.createKey(CropSeasonType.SP_AU);
    public static final ResourceKey<CropGrowControlBuilder> SP_WI = CropRegistry.createKey(CropSeasonType.SP_WI);
    public static final ResourceKey<CropGrowControlBuilder> SU_AU = CropRegistry.createKey(CropSeasonType.SU_AU);
    public static final ResourceKey<CropGrowControlBuilder> SU_WI = CropRegistry.createKey(CropSeasonType.SU_WI);
    public static final ResourceKey<CropGrowControlBuilder> AU_WI = CropRegistry.createKey(CropSeasonType.AU_WI);
    public static final ResourceKey<CropGrowControlBuilder> SP_SU_AU = CropRegistry.createKey(CropSeasonType.SP_SU_AU);
    public static final ResourceKey<CropGrowControlBuilder> SP_SU_WI = CropRegistry.createKey(CropSeasonType.SP_SU_WI);
    public static final ResourceKey<CropGrowControlBuilder> SP_AU_WI = CropRegistry.createKey(CropSeasonType.SP_AU_WI);
    public static final ResourceKey<CropGrowControlBuilder> SU_AU_WI = CropRegistry.createKey(CropSeasonType.SU_AU_WI);
    public static final ResourceKey<CropGrowControlBuilder> ALL = CropRegistry.createKey(CropSeasonType.ALL);
    public static final ResourceKey<CropGrowControlBuilder> ARID = CropRegistry.createKey(CropHumidityType.ARID);
    public static final ResourceKey<CropGrowControlBuilder> ARID_DRY = CropRegistry.createKey(CropHumidityType.ARID_DRY);
    public static final ResourceKey<CropGrowControlBuilder> ARID_AVERAGE = CropRegistry.createKey(CropHumidityType.ARID_AVERAGE);
    public static final ResourceKey<CropGrowControlBuilder> ARID_MOIST = CropRegistry.createKey(CropHumidityType.ARID_MOIST);
    public static final ResourceKey<CropGrowControlBuilder> ARID_HUMID = CropRegistry.createKey(CropHumidityType.ARID_HUMID);
    public static final ResourceKey<CropGrowControlBuilder> DRY = CropRegistry.createKey(CropHumidityType.DRY);
    public static final ResourceKey<CropGrowControlBuilder> DRY_AVERAGE = CropRegistry.createKey(CropHumidityType.DRY_AVERAGE);
    public static final ResourceKey<CropGrowControlBuilder> DRY_MOIST = CropRegistry.createKey(CropHumidityType.DRY_MOIST);
    public static final ResourceKey<CropGrowControlBuilder> DRY_HUMID = CropRegistry.createKey(CropHumidityType.DRY_HUMID);
    public static final ResourceKey<CropGrowControlBuilder> AVERAGE = CropRegistry.createKey(CropHumidityType.AVERAGE);
    public static final ResourceKey<CropGrowControlBuilder> AVERAGE_MOIST = CropRegistry.createKey(CropHumidityType.AVERAGE_MOIST);
    public static final ResourceKey<CropGrowControlBuilder> AVERAGE_HUMID = CropRegistry.createKey(CropHumidityType.AVERAGE_HUMID);
    public static final ResourceKey<CropGrowControlBuilder> MOIST = CropRegistry.createKey(CropHumidityType.MOIST);
    public static final ResourceKey<CropGrowControlBuilder> MOIST_HUMID = CropRegistry.createKey(CropHumidityType.MOIST_HUMID);
    public static final ResourceKey<CropGrowControlBuilder> HUMID = CropRegistry.createKey(CropHumidityType.HUMID);

    public static <K extends Enum<K>, V> Enum2ObjectMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10, K k11, V v11, K k12, V v12, K k13, V v13, K k14, V v14, K k15, V v15, K k16, V v16, K k17, V v17, K k18, V v18, K k19, V v19, K k20, V v20, K k21, V v21, K k22, V v22, K k23, V v23, K k24, V v24) {
        if (k1 == null) {
            throw new IllegalArgumentException("First key cannot be null");
        }
        Class<K> enumType = k1.getDeclaringClass();
        Enum2ObjectMap<K, V> map = new Enum2ObjectMap<K, V>(enumType);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        map.put(k9, v9);
        map.put(k10, v10);
        map.put(k11, v11);
        map.put(k12, v12);
        map.put(k13, v13);
        map.put(k14, v14);
        map.put(k15, v15);
        map.put(k16, v16);
        map.put(k17, v17);
        map.put(k18, v18);
        map.put(k19, v19);
        map.put(k20, v20);
        map.put(k21, v21);
        map.put(k22, v22);
        map.put(k23, v23);
        map.put(k24, v24);
        return map;
    }

    private static ResourceKey<CropGrowControlBuilder> createKey(String name) {
        return ResourceKey.create(ESRegistries.CROP, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static ResourceKey<CropGrowControlBuilder> createKey(CropSeasonType name) {
        return ResourceKey.create(ESRegistries.CROP, (ResourceLocation)EclipticSeasons.rl("seasons/" + name.getRes().getPath().split("/")[1]));
    }

    public static ResourceKey<CropGrowControlBuilder> createKey(CropHumidityType name) {
        return ResourceKey.create(ESRegistries.CROP, (ResourceLocation)EclipticSeasons.rl("humidity/" + name.getRes().getPath().split("/")[1]));
    }

    private static TagKey<Block> createTagKey(ResourceKey<CropGrowControlBuilder> templateName) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)EclipticSeasons.rl("crops/" + templateName.location().getPath().split("/")[1]));
    }

    private static BlockPredicate createTagPredicate(ResourceKey<CropGrowControlBuilder> templateName) {
        return BlockPredicate.Builder.block().of(CropRegistry.createTagKey(templateName)).build();
    }

    public static void bootstrap(BootstrapContext<CropGrowControlBuilder> context) {
        Enum2ObjectMap<SolarTerm, GrowParameter> solarTermListEmpty = new Enum2ObjectMap<SolarTerm, GrowParameter>(SolarTerm.class);
        Enum2ObjectMap<Season, GrowParameter> seasonListEmpty = new Enum2ObjectMap<Season, GrowParameter>(Season.class);
        Enum2ObjectMap<Humidity, GrowParameter> humidListEmpty = new Enum2ObjectMap<Humidity, GrowParameter>(Humidity.class);
        Optional empty = Optional.empty();
        Optional<GrowParameter> emptyGP = Optional.empty();
        Optional<GrowParameter> emptyGP2 = Optional.empty();
        Optional<BlockPredicate> emptyBP = Optional.empty();
        HolderGetter blockHolderGetter = context.lookup(Registries.BLOCK);
        HolderGetter biomeHolderGetter = context.lookup(Registries.BIOME);
        HolderGetter cropGetter = context.lookup(ESRegistries.CROP);
        HolderGetter cropClimateTypeHolderGetter = context.lookup(ESRegistries.AGRO_CLIMATE);
        HolderSet.Direct temperate = HolderSet.direct((Holder[])new Holder[]{cropClimateTypeHolderGetter.getOrThrow(AgroClimateRegistry.TEMPERATE)});
        Optional<BlockPredicate> icePredicate = Optional.of(new BlockPredicate(Optional.of(blockHolderGetter.getOrThrow(BlockTags.ICE)), Optional.empty(), Optional.empty()));
        context.register(SPRING, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SPRING), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.25f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.register(SUMMER, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SUMMER), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.register(AUTUMN, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(AUTUMN), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.97f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.register(WINTER, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(WINTER), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.7f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.register(SP_SU, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_SU), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.register(SP_AU, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_AU), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.64f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.register(SP_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.64f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.12f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.25f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.6f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.register(SU_AU, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SU_AU), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.25f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.register(SU_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SU_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.01f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.02f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.6f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.register(AU_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(AU_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.15f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.05f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.64f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.75f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.75f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.register(SP_SU_AU, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_SU_AU), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.35f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.64f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.0f).end())), seasonListEmpty, humidListEmpty, icePredicate));
        context.register(SP_SU_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_SU_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.55f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.register(SP_AU_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SP_AU_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(1.025f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.01f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.25f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.45f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.65f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.55f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.45f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.register(SU_AU_WI, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(SU_AU_WI), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.0f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.1f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.2f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.3f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.4f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        context.register(ALL, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)temperate, CropRegistry.createTagPredicate(ALL), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, new Enum2ObjectMap<SolarTerm, GrowParameter>(CropRegistry.of(SolarTerm.BEGINNING_OF_SPRING, GrowParameter.builder().growChance(0.45f).end(), SolarTerm.RAIN_WATER, GrowParameter.builder().growChance(0.55f).end(), SolarTerm.INSECTS_AWAKENING, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.SPRING_EQUINOX, GrowParameter.builder().growChance(0.85f).end(), SolarTerm.FRESH_GREEN, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.GRAIN_RAIN, GrowParameter.builder().growChance(0.95f).end(), SolarTerm.BEGINNING_OF_SUMMER, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.LESSER_FULLNESS, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GRAIN_IN_EAR, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.SUMMER_SOLSTICE, GrowParameter.builder().growChance(1.0f).end(), SolarTerm.LESSER_HEAT, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.GREATER_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.BEGINNING_OF_AUTUMN, GrowParameter.builder().growChance(0.9f).end(), SolarTerm.END_OF_HEAT, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.WHITE_DEW, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.AUTUMNAL_EQUINOX, GrowParameter.builder().growChance(0.8f).end(), SolarTerm.COLD_DEW, GrowParameter.builder().growChance(0.7f).end(), SolarTerm.FIRST_FROST, GrowParameter.builder().growChance(0.6f).end(), SolarTerm.BEGINNING_OF_WINTER, GrowParameter.builder().growChance(0.5f).end(), SolarTerm.LIGHT_SNOW, GrowParameter.builder().growChance(0.48f).end(), SolarTerm.HEAVY_SNOW, GrowParameter.builder().growChance(0.45f).end(), SolarTerm.WINTER_SOLSTICE, GrowParameter.builder().growChance(0.4f).end(), SolarTerm.LESSER_COLD, GrowParameter.builder().growChance(0.37f).end(), SolarTerm.GREATER_COLD, GrowParameter.builder().growChance(0.35f).end())), seasonListEmpty, humidListEmpty, emptyBP));
        HolderSet.Named allHolderSet = (HolderSet.Named)cropClimateTypeHolderGetter.get(CropClimateTags.ALL).get();
        context.register(ARID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(ARID), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(1.01f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.5f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.15f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.8f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.5f).end())), emptyBP));
        context.register(ARID_DRY, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(ARID_DRY), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.99f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(1.0f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.1f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.0f).end())), emptyBP));
        context.register(ARID_AVERAGE, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(ARID_AVERAGE), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(1.01f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.1f).end())), emptyBP));
        context.register(ARID_MOIST, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(ARID_MOIST), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.9f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.9f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.35f).end())), emptyBP));
        context.register(ARID_HUMID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(ARID_HUMID), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.8f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.85f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(1.0f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.95f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.8f).end())), emptyBP));
        context.register(DRY, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(DRY), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.4f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.45f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.15f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.0f).end())), emptyBP));
        context.register(DRY_AVERAGE, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(DRY_AVERAGE), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.3f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.4f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.1f).end())), emptyBP));
        context.register(DRY_MOIST, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(DRY_MOIST), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.95f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.95f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.35f).end())), emptyBP));
        context.register(DRY_HUMID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(DRY_HUMID), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.25f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.9f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(1.0f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(1.0f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.9f).end())), emptyBP));
        context.register(AVERAGE, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(AVERAGE), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.07f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.45f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.45f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.07f).end())), emptyBP));
        context.register(AVERAGE_MOIST, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(AVERAGE_MOIST), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.1f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.97f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.4f).end())), emptyBP));
        context.register(AVERAGE_HUMID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(AVERAGE_HUMID), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.05f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.95f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.95f).end())), emptyBP));
        context.register(MOIST, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(MOIST), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.8f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.15f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.45f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(1.025f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(0.5f).end())), emptyBP));
        context.register(MOIST_HUMID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(MOIST_HUMID), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.8f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.1f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.35f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(1.0f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(1.0f).end())), emptyBP));
        context.register(HUMID, (Object)new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)allHolderSet, CropRegistry.createTagPredicate(HUMID), (HolderSet<CropGrowControlBuilder>)HolderSet.empty(), emptyGP, emptyGP2, solarTermListEmpty, seasonListEmpty, new Enum2ObjectMap<Humidity, GrowParameter>((Map<Humidity, GrowParameter>)ImmutableMap.of((Object)Humidity.ARID, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.5f).end(), (Object)Humidity.DRY, (Object)GrowParameter.builder().growChance(0.0f).fertileChance(0.8f).end(), (Object)Humidity.AVERAGE, (Object)GrowParameter.builder().growChance(0.3f).end(), (Object)Humidity.MOIST, (Object)GrowParameter.builder().growChance(0.6f).end(), (Object)Humidity.HUMID, (Object)GrowParameter.builder().growChance(1.025f).end())), emptyBP));
    }
}

