/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.tag.EclipticBlockTags;
import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.api.data.misc.PosAndBlockStateCheck;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.List;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class HumidityControlRegistry {
    public static final ResourceKey<HumidityControl> sponge = HumidityControlRegistry.createKey("sponge");
    public static final ResourceKey<HumidityControl> wet_sponge = HumidityControlRegistry.createKey("wet_sponge");

    private static ResourceKey<HumidityControl> createKey(String name) {
        return ResourceKey.create(ESRegistries.HUMIDITY_CONTROL, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static void bootstrap(BootstrapContext<HumidityControl> context) {
        context.register(sponge, (Object)new HumidityControl(new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.SPONGE}), 1), Items.WET_SPONGE.getDefaultInstance(), 5, -1, 6000, List.of(), true));
        context.register(wet_sponge, (Object)new HumidityControl(new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{Items.WET_SPONGE}), 1), Items.SPONGE.getDefaultInstance(), 5, 1, 6000, List.of(new PosAndBlockStateCheck(new Vec3i(0, -1, 0), BlockPredicate.Builder.block().of(EclipticBlockTags.SOFT_HEAT_SOURCES).build())), true));
    }
}

