/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.registry;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.CropClimateTags;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.quest.SeasonQuest;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class SeasonQuestRegistry {
    public static final ResourceKey<SeasonQuest> SPRING_CORE = SeasonQuestRegistry.createKey("spring_core");
    public static final ResourceKey<SeasonQuest> SUMMER_CORE = SeasonQuestRegistry.createKey("summer_core");
    public static final ResourceKey<SeasonQuest> AUTUMN_CORE = SeasonQuestRegistry.createKey("autumn_core");
    public static final ResourceKey<SeasonQuest> WINTER_CORE = SeasonQuestRegistry.createKey("winter_core");

    private static ResourceKey<SeasonQuest> createKey(String name) {
        return ResourceKey.create(ESRegistries.SEASON_QUEST, (ResourceLocation)EclipticSeasons.rl(name));
    }

    public static void bootstrap(BootstrapContext<SeasonQuest> context) {
        HolderGetter cropClimateTypeHolderGetter = context.lookup(ESRegistries.AGRO_CLIMATE);
        context.register(SPRING_CORE, (Object)SeasonQuest.builder().setTittle((Component)Component.translatable((String)ESRegistries.createLangKey(SPRING_CORE))).setStart(SolarTerm.SPRING_EQUINOX).setEnd(SolarTerm.BEGINNING_OF_SUMMER).addNeed(Items.WHEAT, 192).addAward((Item)ItemRegistry.spring_greenhouse_essence_item.get()).setClimate((HolderSet<AgroClimaticZone>)cropClimateTypeHolderGetter.getOrThrow(CropClimateTags.ALL)).setWeight(10).setGlowing(true).setColor(Season.SPRING.getColor().getColor()).build());
        context.register(SUMMER_CORE, (Object)SeasonQuest.builder().setTittle((Component)Component.translatable((String)ESRegistries.createLangKey(SUMMER_CORE))).setStart(SolarTerm.SUMMER_SOLSTICE).setEnd(SolarTerm.BEGINNING_OF_AUTUMN).addNeed(Items.MELON, 48).addAward((Item)ItemRegistry.summer_greenhouse_essence_item.get()).setClimate((HolderSet<AgroClimaticZone>)cropClimateTypeHolderGetter.getOrThrow(CropClimateTags.ALL)).setWeight(10).setGlowing(true).setColor(Season.SUMMER.getColor().getColor()).build());
        context.register(AUTUMN_CORE, (Object)SeasonQuest.builder().setTittle((Component)Component.translatable((String)ESRegistries.createLangKey(AUTUMN_CORE))).setStart(SolarTerm.AUTUMNAL_EQUINOX).setEnd(SolarTerm.BEGINNING_OF_WINTER).addNeed(Items.PUMPKIN, 96).addNeed(Items.CARROT, 64).addNeed(Items.BEETROOT, 64).addAward((Item)ItemRegistry.autumn_greenhouse_essence_item.get()).setClimate((HolderSet<AgroClimaticZone>)cropClimateTypeHolderGetter.getOrThrow(CropClimateTags.ALL)).setWeight(10).setGlowing(true).setColor(Season.AUTUMN.getColor().getColor()).build());
        context.register(WINTER_CORE, (Object)SeasonQuest.builder().setTittle((Component)Component.translatable((String)ESRegistries.createLangKey(WINTER_CORE))).setStart(SolarTerm.WINTER_SOLSTICE).setEnd(SolarTerm.BEGINNING_OF_SPRING).addNeed(Items.SWEET_BERRIES, 96).addAward((Item)ItemRegistry.winter_greenhouse_essence_item.get()).setClimate((HolderSet<AgroClimaticZone>)cropClimateTypeHolderGetter.getOrThrow(CropClimateTags.ALL)).setWeight(10).setGlowing(true).setColor(Season.WINTER.getColor().getColor()).build());
    }
}

