/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.DetectedVersion;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ESModFilePackResources
extends PathPackResources {
    protected final IModFile modFile;
    protected final String sourcePath;
    private final PackMetadataSection bindSection;

    public ESModFilePackResources(PackLocationInfo locationInfo, IModFile modFile, String sourcePath) {
        super(locationInfo, modFile.findResource(new String[]{sourcePath}));
        this.modFile = modFile;
        this.sourcePath = sourcePath;
        this.bindSection = new PackMetadataSection(locationInfo.title(), DetectedVersion.BUILT_IN.getPackVersion(PackType.CLIENT_RESOURCES), Optional.empty());
    }

    @Nullable
    public <T> T getMetadataSection(@NotNull MetadataSectionSerializer<T> pDeserializer) throws IOException {
        IoSupplier iosupplier = this.getRootResource(new String[]{"pack.mcmeta"});
        if (iosupplier == null) {
            return (T)(pDeserializer == PackMetadataSection.TYPE ? this.bindSection : null);
        }
        try (InputStream inputstream = (InputStream)iosupplier.get();){
            Object object = ESModFilePackResources.getMetadataFromStream(pDeserializer, (InputStream)inputstream);
            return (T)object;
        }
    }

    public static class PathResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final Path content;
        protected final IModFile modFile;

        public PathResourcesSupplier(IModFile modFile, Path pContent) {
            this.content = pContent;
            this.modFile = modFile;
        }

        @NotNull
        public ESModFilePackResources openPrimary(@NotNull PackLocationInfo pLocation) {
            return new ESModFilePackResources(pLocation, this.modFile, this.content.toString());
        }

        @NotNull
        public PackResources openFull(@NotNull PackLocationInfo pLocation, Pack.Metadata pMetadata) {
            ESModFilePackResources packResources = this.openPrimary(pLocation);
            List list = pMetadata.overlays();
            if (list.isEmpty()) {
                return packResources;
            }
            ArrayList<PathPackResources> list1 = new ArrayList<PathPackResources>(list.size());
            for (String s : list) {
                Path path = this.content.resolve(s);
                list1.add(new PathPackResources(pLocation, path));
            }
            return null;
        }
    }
}

