/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.resource;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.common.resource.ESModFilePackResources;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.locating.IModFile;

public class FakeResourceManagerHelperUtil {
    private static final PackSelectionConfig FEATURE_SELECTION_CONFIG = new PackSelectionConfig(true, Pack.Position.BOTTOM, false);

    public static void registerBuiltinResourcePack(AddPackFindersEvent event, ResourceLocation packId, ModFile modFile, PackSource source) {
        String languageKey = packId.toLanguageKey("pack");
        FakeResourceManagerHelperUtil.registerBuiltinResourcePack(event, packId, modFile, (Component)Component.translatable((String)languageKey), source);
    }

    public static void registerBuiltinResourcePack(AddPackFindersEvent event, ResourceLocation packId, ModFile modFile, Component translate, PackSource source) {
        String packIdLanguageKey = packId.toLanguageKey() + "_" + event.getPackType().getSerializedName();
        PackLocationInfo packLocationInfo = new PackLocationInfo(packIdLanguageKey, translate, source, Optional.of(FakeResourceManagerHelperUtil.knowPack(packIdLanguageKey)));
        event.addRepositorySource(consumer -> consumer.accept(Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)new ESModFilePackResources.PathResourcesSupplier((IModFile)modFile, Path.of("resourcepacks/" + packId.getPath(), new String[0])), (PackType)event.getPackType(), (PackSelectionConfig)FEATURE_SELECTION_CONFIG)));
    }

    public static void registerBuiltinResourcePack(AddPackFindersEvent event, ResourceLocation packId, ModFile modFile, MutableComponent translate, PackType packType, PackSource source) {
        FakeResourceManagerHelperUtil.registerBuiltinResourcePack(event, packId, modFile, translate, packType, source, FEATURE_SELECTION_CONFIG);
    }

    public static void registerBuiltinResourcePack(AddPackFindersEvent event, ResourceLocation packId, ModFile modFile, MutableComponent translate, PackType packType, PackSource source, PackSelectionConfig selectionConfig) {
        if (event.getPackType() == packType) {
            String packIdLanguageKey = packId.toLanguageKey() + "_" + packType.getSerializedName();
            PackLocationInfo packLocationInfo = new PackLocationInfo(packIdLanguageKey, (Component)translate, source, Optional.of(FakeResourceManagerHelperUtil.knowPack(packIdLanguageKey)));
            event.addRepositorySource(consumer -> consumer.accept(Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)new ESModFilePackResources.PathResourcesSupplier((IModFile)modFile, Path.of("resourcepacks/" + packId.getPath(), new String[0])), (PackType)packType, (PackSelectionConfig)selectionConfig)));
        }
    }

    public static void registerBuiltinResourcePack(AddPackFindersEvent event, String namespace, String pack, ModFile modFile, MutableComponent translate, PackType packType, PackSource source, PackSelectionConfig selectionConfig) {
        if (event.getPackType() == packType) {
            String packIdLanguageKey = namespace + "_" + packType.getSerializedName();
            PackLocationInfo packLocationInfo = new PackLocationInfo(packIdLanguageKey, (Component)translate, source, Optional.of(FakeResourceManagerHelperUtil.knowPack(packIdLanguageKey)));
            event.addRepositorySource(consumer -> consumer.accept(Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)new ESModFilePackResources.PathResourcesSupplier((IModFile)modFile, Path.of("resourcepacks/" + pack, new String[0])), (PackType)packType, (PackSelectionConfig)selectionConfig)));
        }
    }

    public static void registerBuiltinDataPack(AddPackFindersEvent event, ModFile modContainer, String packId) {
        FakeResourceManagerHelperUtil.registerBuiltinResourcePack(event, EclipticSeasons.rl("compat_" + packId), modContainer, Component.translatable((String)("pack.eclipticseasons." + packId)), PackType.SERVER_DATA, PackSource.BUILT_IN);
    }

    public static KnownPack knowPack(String pName) {
        return new KnownPack("eclipticseasons", pName, SharedConstants.getCurrentVersion().getId());
    }
}

