/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.compat.ctm;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.compat.ctm.CtmProperties;
import it.unimi.dsi.fastutil.Pair;
import java.io.InputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;

public class CtmLoader {
    private final ResourceManager resourceManager;
    public Map<Block, CtmProperties> ctmStates = new IdentityHashMap<Block, CtmProperties>();
    public Map<ResourceLocation, Void> ctmTiles = new HashMap<ResourceLocation, Void>();

    public CtmLoader(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public static CTMLoadingResult loadAll(ResourceManager resourceManager) {
        return new CtmLoader(resourceManager).loadAll();
    }

    private CTMLoadingResult loadAll() {
        int packPriority = 0;
        Iterator iterator = this.resourceManager.listPacks().iterator();
        while (iterator.hasNext()) {
            PackResources pack = (PackResources)iterator.next();
            this.loadAll(pack, packPriority);
            ++packPriority;
        }
        return new CTMLoadingResult(this.ctmStates, this.ctmTiles);
    }

    private void loadAll(PackResources pack, int packPriority) {
        for (String namespace : pack.getNamespaces(PackType.CLIENT_RESOURCES)) {
            pack.listResources(PackType.CLIENT_RESOURCES, namespace, "optifine/ctm", (resourceId, inputSupplier) -> {
                if (resourceId.getPath().endsWith(".properties")) {
                    try (InputStream stream = (InputStream)inputSupplier.get();){
                        String patt0$temp;
                        Properties properties = new Properties();
                        properties.load(stream);
                        for (Pair<Block, CtmProperties> pair : CtmProperties.parse(resourceId, (IoSupplier<InputStream>)inputSupplier, properties)) {
                            this.ctmStates.compute((Block)pair.key(), (block, ctmProperties) -> {
                                if (ctmProperties == null) {
                                    return (CtmProperties)pair.value();
                                }
                                ctmProperties.blockStates.putAll(((CtmProperties)pair.value()).blockStates);
                                return ctmProperties;
                            });
                        }
                        String method = properties.getProperty("method", null);
                        if (method != null && method.contains("ctm") && (patt0$temp = properties.getProperty("matchTiles", null)) instanceof String) {
                            String[] split;
                            String s = patt0$temp;
                            for (String string : split = s.split(" ")) {
                                try {
                                    ResourceLocation parse = EclipticSeasons.parse(string);
                                    String[] split1 = parse.getPath().split("textures/");
                                    this.ctmTiles.putIfAbsent(ResourceLocation.fromNamespaceAndPath((String)parse.getNamespace(), (String)(split1.length == 2 ? split1[1] : "block/" + parse.getPath())), null);
                                }
                                catch (ResourceLocationException resourceLocationException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public static class CTMLoadingResult {
        public Map<Block, CtmProperties> ctmStates;
        public Map<ResourceLocation, Void> ctmTiles;

        public CTMLoadingResult(Map<Block, CtmProperties> ctmStates, Map<ResourceLocation, Void> ctmTiles) {
            this.ctmStates = ctmStates;
            this.ctmTiles = ctmTiles;
        }
    }
}

