/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.compat.ctm;

import com.teamtea.eclipticseasons.EclipticSeasons;
import it.unimi.dsi.fastutil.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CtmProperties {
    private final Properties properties;
    private final ResourceLocation resourceId;
    private final PackResources pack;
    private final int packPriority;
    private final ResourceManager resourceManager;
    private final String method;
    final IdentityHashMap<BlockState, Integer> blockStates = new IdentityHashMap();
    private static final List<Pair<String, Set<String>>> EMPTY_STRINGS = List.of();

    public CtmProperties(Properties properties, ResourceLocation resourceId, PackResources pack, int packPriority, ResourceManager resourceManager, String method) {
        this.properties = properties;
        this.resourceId = resourceId;
        this.pack = pack;
        this.packPriority = packPriority;
        this.resourceManager = resourceManager;
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ResourceLocation getResourceId() {
        return this.resourceId;
    }

    public PackResources getPack() {
        throw new UnsupportedOperationException();
    }

    public int getPackPriority() {
        throw new UnsupportedOperationException();
    }

    public ResourceManager getResourceManager() {
        throw new UnsupportedOperationException();
    }

    public boolean matches(BlockState blockState) {
        return this.blockStates.isEmpty() || this.blockStates.containsKey(blockState);
    }

    public static List<Pair<Block, CtmProperties>> parse(ResourceLocation resourceLocation, IoSupplier<InputStream> resource, Properties properties) {
        String matchBlocks;
        String method;
        ArrayList<Pair<Block, CtmProperties>> pairResult = new ArrayList<Pair<Block, CtmProperties>>();
        if (!properties.isEmpty() && (method = properties.getProperty("method", null)) != null && method.contains("ctm") && (matchBlocks = properties.getProperty("matchBlocks", null)) != null) {
            try {
                List<Pair<Block, List<BlockState>>> pairs = CtmProperties.parseBlockStates(properties, "matchBlocks", resourceLocation);
                if (pairs != null) {
                    for (Pair<Block, List<BlockState>> pair : pairs) {
                        CtmProperties ctmProperties = new CtmProperties(properties, resourceLocation, null, 0, null, method);
                        for (BlockState blockState : (List)pair.second()) {
                            ctmProperties.blockStates.putIfAbsent(blockState, 0);
                        }
                        pairResult.add((Pair<Block, CtmProperties>)Pair.of((Object)((Block)pair.first()), (Object)ctmProperties));
                    }
                }
            }
            catch (IndexOutOfBoundsException | ResourceLocationException ignore) {
                EclipticSeasons.logger(matchBlocks, "can not parse CTM properties");
            }
        }
        return pairResult;
    }

    @NotNull
    public static Properties parseProperties(Resource resource) {
        Properties properties = new Properties();
        try (BufferedReader br = resource.openAsReader();){
            properties.load(br);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    @Nullable
    public static List<Pair<Block, List<BlockState>>> parseBlockStates(Properties properties, String propertyKey, ResourceLocation resourceId) {
        String blockStatesStr = properties.getProperty(propertyKey);
        ArrayList<Pair> pairs = null;
        if (blockStatesStr == null) {
            return null;
        }
        String[] blockStateStrs = blockStatesStr.trim().split(" ");
        if (blockStateStrs.length != 0) {
            pairs = new ArrayList<Pair>();
            int blockStateStrsLength = blockStateStrs.length;
            for (int i = 0; i < blockStateStrsLength; ++i) {
                String blockStateStr = blockStateStrs[i].strip();
                Pair<String, List<Pair<String, Set<String>>>> parseBlockStates = CtmProperties.parseBlockState(blockStateStr);
                Block block1 = (Block)BuiltInRegistries.BLOCK.get(EclipticSeasons.parse((String)parseBlockStates.first()));
                if (block1 == Blocks.AIR) continue;
                boolean checkState = !((List)parseBlockStates.value()).isEmpty();
                ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
                if (checkState) {
                    for (BlockState possibleState : block1.getStateDefinition().getPossibleStates()) {
                        boolean isRight = true;
                        for (Pair pair : (List)parseBlockStates.value()) {
                            Property property = block1.getStateDefinition().getProperty((String)pair.first());
                            if (property == null || ((Set)pair.second()).contains(possibleState.getValue(property).toString())) continue;
                            isRight = false;
                            break;
                        }
                        if (!isRight) continue;
                        blockStates.add(possibleState);
                    }
                }
                pairs.add(Pair.of((Object)block1, blockStates));
            }
        }
        return pairs;
    }

    public static Pair<String, List<Pair<String, Set<String>>>> parseBlockState(String input) {
        String[] parts = input.split(":");
        if (parts.length <= 2 && !input.contains("=")) {
            return Pair.of((Object)input, EMPTY_STRINGS);
        }
        Object id = "";
        int startIndex = 2;
        String[] parts_temp = input.split("=");
        if (parts.length <= 2 || parts_temp[0].length() < parts[0].length() + parts[1].length()) {
            id = parts[0];
            startIndex = 1;
        } else {
            String mod = parts[0];
            String path = parts[1];
            id = mod + ":" + path;
        }
        ArrayList<Pair> predicates = new ArrayList<Pair>();
        for (int i = startIndex; i < parts.length; ++i) {
            String part = parts[i];
            String[] split = part.split("=");
            if (split.length != 2) continue;
            String propertyName = split[0];
            Set values = Arrays.stream(split[1].split(",")).collect(Collectors.toSet());
            predicates.add(Pair.of((Object)propertyName, values));
        }
        return Pair.of((Object)id, predicates);
    }
}

