/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.config;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.compat.CompatModule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CommonConfig {
    public static final ModConfigSpec COMMON_CONFIG = (ModConfigSpec)new ModConfigSpec.Builder().configure(CommonConfig::new).getRight();
    private static boolean seasonDefinition = false;
    private static boolean useSolarWeather = true;
    private static boolean enableWeatherRegion = true;
    private static boolean forceCropCompatMode = false;
    private static boolean snowyWinter = true;
    private static boolean snowInWorld = true;
    private static final int[] dayTimesForSeason = new int[SolarTerm.collectValues().length];
    private static boolean useDayTimes = false;
    private static boolean cropHumidityTransition = true;
    private static final Set<Block> forceBlocksNotSnowy = new HashSet<Block>();

    protected CommonConfig(ModConfigSpec.Builder builder) {
        Season.load(builder);
        Weather.load(builder);
        Temperature.load(builder);
        Crop.load(builder);
        Animal.load(builder);
        Map.load(builder);
        Snow.load(builder);
        CompatModule.CommonConfig.load(builder);
        Debug.load(builder);
    }

    public static boolean validSeason(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            try {
                com.teamtea.eclipticseasons.api.constant.solar.Season.valueOf(s);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return o instanceof com.teamtea.eclipticseasons.api.constant.solar.Season;
    }

    public static boolean validSolarTerm(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            try {
                SolarTerm.valueOf(s);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return o instanceof SolarTerm;
    }

    public static Set<com.teamtea.eclipticseasons.api.constant.solar.Season> castSeasons(List<? extends String> strings) {
        EnumSet<com.teamtea.eclipticseasons.api.constant.solar.Season> es1 = EnumSet.noneOf(com.teamtea.eclipticseasons.api.constant.solar.Season.class);
        for (String string : strings) {
            es1.add(com.teamtea.eclipticseasons.api.constant.solar.Season.valueOf(string));
        }
        return es1;
    }

    public static List<com.teamtea.eclipticseasons.api.constant.solar.Season> castSeasonList(List<? extends String> strings) {
        ArrayList<com.teamtea.eclipticseasons.api.constant.solar.Season> es1 = new ArrayList<com.teamtea.eclipticseasons.api.constant.solar.Season>();
        for (String string : strings) {
            es1.add(com.teamtea.eclipticseasons.api.constant.solar.Season.valueOf(string));
        }
        return es1;
    }

    public static Set<SolarTerm> castSolarTerms(List<? extends String> strings) {
        EnumSet<SolarTerm> es1 = EnumSet.noneOf(SolarTerm.class);
        for (String string : strings) {
            es1.add(SolarTerm.valueOf(string));
        }
        return es1;
    }

    public static List<SolarTerm> castSolarTermList(List<? extends String> strings) {
        ArrayList<SolarTerm> es1 = new ArrayList<SolarTerm>();
        for (String string : strings) {
            es1.add(SolarTerm.valueOf(string));
        }
        return es1;
    }

    public static void UpdateConfig(ModConfigEvent modConfigEvent) {
        if (!(modConfigEvent instanceof ModConfigEvent.Unloading) && modConfigEvent.getConfig().getSpec() == COMMON_CONFIG) {
            useSolarWeather = (Boolean)Weather.useSolarWeather.get();
            enableWeatherRegion = (Boolean)Weather.enableWeatherRegion.get();
            forceCropCompatMode = (Boolean)Crop.forceCompatMode.get();
            snowyWinter = (Boolean)Snow.snowyWinter.get();
            snowInWorld = (Boolean)Snow.snowInWorld.get() != false && snowyWinter;
            seasonDefinition = (Boolean)Season.seasonDefinition.get();
            cropHumidityTransition = (Boolean)Crop.cropHumidityTransition.get();
            int[] ints = Stream.of(Season.springDayTimes, Season.summerDayTimes, Season.autumnDayTimes, Season.winterDayTimes, Season.noneDayTimes).map(ModConfigSpec.ConfigValue::get).flatMap(Collection::stream).mapToInt(Integer::intValue).toArray();
            if (ints.length == dayTimesForSeason.length) {
                System.arraycopy(ints, 0, dayTimesForSeason, 0, ints.length);
                boolean isSame = true;
                for (int i = 0; i < dayTimesForSeason.length; ++i) {
                    if (dayTimesForSeason[i] == SolarTerm.get(i).getOriginalDayTime()) continue;
                    isSame = false;
                    break;
                }
                useDayTimes = !isSame;
            } else {
                useDayTimes = false;
                EclipticSeasons.logger("Invalid Day Times length in configuration:", ints.length);
            }
            forceBlocksNotSnowy.clear();
            for (String s : (List)Snow.blocksNotSnowy.get()) {
                Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)s));
                if (block == Blocks.AIR) continue;
                forceBlocksNotSnowy.add(block);
            }
        }
    }

    @Generated
    public static boolean isSeasonDefinition() {
        return seasonDefinition;
    }

    @Generated
    public static boolean isUseSolarWeather() {
        return useSolarWeather;
    }

    @Generated
    public static boolean isEnableWeatherRegion() {
        return enableWeatherRegion;
    }

    @Generated
    public static boolean isForceCropCompatMode() {
        return forceCropCompatMode;
    }

    @Generated
    public static boolean isSnowyWinter() {
        return snowyWinter;
    }

    @Generated
    public static boolean isSnowInWorld() {
        return snowInWorld;
    }

    @Generated
    public static int[] getDayTimesForSeason() {
        return dayTimesForSeason;
    }

    @Generated
    public static boolean isUseDayTimes() {
        return useDayTimes;
    }

    @Generated
    public static boolean isCropHumidityTransition() {
        return cropHumidityTransition;
    }

    @Generated
    public static Set<Block> getForceBlocksNotSnowy() {
        return forceBlocksNotSnowy;
    }

    public static class Season {
        public static ModConfigSpec.BooleanValue enableInform;
        public static ModConfigSpec.BooleanValue enableInformIcon;
        public static ModConfigSpec.BooleanValue enableLocalInfoCalendar;
        public static ModConfigSpec.BooleanValue calendarItemHint;
        public static ModConfigSpec.IntValue lastingDaysOfEachTerm;
        public static ModConfigSpec.IntValue initialSolarTermIndex;
        public static ModConfigSpec.ConfigValue<List<? extends String>> validDimensions;
        public static ModConfigSpec.BooleanValue daylightChange;
        public static ModConfigSpec.ConfigValue<List<? extends Integer>> springDayTimes;
        public static ModConfigSpec.ConfigValue<List<? extends Integer>> summerDayTimes;
        public static ModConfigSpec.ConfigValue<List<? extends Integer>> autumnDayTimes;
        public static ModConfigSpec.ConfigValue<List<? extends Integer>> winterDayTimes;
        public static ModConfigSpec.ConfigValue<List<? extends Integer>> noneDayTimes;
        public static ModConfigSpec.BooleanValue dynamicSnowTerm;
        public static ModConfigSpec.BooleanValue seasonDefinition;

        private static void load(ModConfigSpec.Builder builder) {
            builder.push("Season");
            lastingDaysOfEachTerm = builder.comment("The lasting days of each term, while 4 seasons in 1 year, 6 terms in 1 season.").defineInRange("LastingDaysOfEachTerm", 7, 1, 5000);
            initialSolarTermIndex = builder.comment("The index of the initial solar term, and note it only can be used to first start the world with the mod.").defineInRange("InitialSolarTermIndex", 4, 1, 24);
            seasonDefinition = builder.comment("Enable the season definitions system.").define("EnableSeasonDefinition", false);
            enableInform = builder.comment("Enable solar term change inform.").define("EnableInform", true);
            enableInformIcon = builder.comment("Whether send inform with icon.").define("EnableInformIcon", true);
            enableLocalInfoCalendar = builder.comment("Enable local calendar and local info synchronization.").define("EnableLocalInfoAndCalendar", false);
            calendarItemHint = builder.comment("Whether to pop up the solar term reminder when the calendar item cannot be placed.").define("CalendarItemHint", false);
            daylightChange = builder.comment("In summer, the days are long and the nights are short, while in winter, the days are short and the nights are long.").define("DynamicDaylightDuration", true);
            validDimensions = builder.comment("List of dimensions where season effects apply. Must be natural worlds with a day-night cycle.").defineListAllowEmpty("ValidDimensions", () -> List.of(Level.OVERWORLD.location().toString()), () -> Level.OVERWORLD.location().toString(), o -> {
                String s;
                return o instanceof String && ResourceLocation.tryParse((String)(s = (String)o)) != null;
            });
            springDayTimes = builder.comment("Day time length of spring, divided into six periods according to the solar term table.").defineList(List.of("SpringDayTimes"), () -> List.of(Integer.valueOf(10500), Integer.valueOf(11000), Integer.valueOf(11500), Integer.valueOf(12000), Integer.valueOf(12500), Integer.valueOf(13000)), () -> 12000, o -> {
                Integer i;
                return o instanceof Integer && (i = (Integer)o) >= 0 && i <= 24000;
            }, ModConfigSpec.Range.of((int)6, (int)6));
            summerDayTimes = builder.comment("Day time length of summer, divided into six periods according to the solar term table.").defineList(List.of("SummerDayTimes"), () -> List.of(Integer.valueOf(13500), Integer.valueOf(14000), Integer.valueOf(14500), Integer.valueOf(15000), Integer.valueOf(14500), Integer.valueOf(14000)), () -> 12000, o -> {
                Integer i;
                return o instanceof Integer && (i = (Integer)o) >= 0 && i <= 24000;
            }, ModConfigSpec.Range.of((int)6, (int)6));
            autumnDayTimes = builder.comment("Day time length of autumn, divided into six periods according to the solar term table.").defineList(List.of("AutumnDayTimes"), () -> List.of(Integer.valueOf(13500), Integer.valueOf(13000), Integer.valueOf(12500), Integer.valueOf(12000), Integer.valueOf(11500), Integer.valueOf(11000)), () -> 12000, o -> {
                Integer i;
                return o instanceof Integer && (i = (Integer)o) >= 0 && i <= 24000;
            }, ModConfigSpec.Range.of((int)6, (int)6));
            winterDayTimes = builder.comment("Day time length of winter, divided into six periods according to the solar term table.").defineList(List.of("WinterDayTimes"), () -> List.of(Integer.valueOf(10500), Integer.valueOf(10000), Integer.valueOf(9500), Integer.valueOf(9000), Integer.valueOf(9500), Integer.valueOf(10000)), () -> 12000, o -> {
                Integer i;
                return o instanceof Integer && (i = (Integer)o) >= 0 && i <= 24000;
            }, ModConfigSpec.Range.of((int)6, (int)6));
            noneDayTimes = builder.comment("Day time length of none season, divided into six periods according to the solar term table.").defineList(List.of("NoneDayTimes"), () -> List.of(Integer.valueOf(12000)), () -> 12000, o -> {
                Integer i;
                return o instanceof Integer && (i = (Integer)o) >= 0 && i <= 24000;
            }, ModConfigSpec.Range.of((int)1, (int)1));
            dynamicSnowTerm = builder.comment("The timing of snowfall now varies within a certain range each year.").define("DynamicSnowTerm", true);
            builder.pop();
        }
    }

    public static class Weather {
        public static ModConfigSpec.BooleanValue useSolarWeather;
        public static ModConfigSpec.BooleanValue enableWeatherRegion;
        public static ModConfigSpec.BooleanValue notRainInDesert;
        public static ModConfigSpec.IntValue rainChanceMultiplier;
        public static ModConfigSpec.IntValue thunderChanceMultiplier;
        public static ModConfigSpec.BooleanValue shouldInitWeather;
        public static ModConfigSpec.BooleanValue clearAfterSleep;

        private static void load(ModConfigSpec.Builder builder) {
            builder.push("Weather");
            useSolarWeather = builder.comment("Enable the Ecliptic local weather system that adapts weather to each biome.").define("UseSolarWeather", true);
            enableWeatherRegion = builder.comment("Enable weather regions, linking specific biomes to particular weather to prevent scattered patterns.").define("EnableWeatherRegion", true);
            notRainInDesert = builder.comment("Prevent rain from occurring in biomes without precipitation like desert.").define("NotRainInDesert", false);
            shouldInitWeather = builder.comment("Set it true to initialize weather and snow when loading the mod or level for the first time.").define("ShouldInitWeather", false);
            rainChanceMultiplier = builder.comment("Multiplier (0-1000) affecting the chance of rain. Higher values make rain more likely.").defineInRange("RainChancePercentMultiplier", 40, 0, 1000);
            thunderChanceMultiplier = builder.comment("Multiplier (0-1000) affecting the chance of thunder. Higher values make thunder more likely.").defineInRange("ThunderChancePercentMultiplier", 20, 0, 1000);
            clearAfterSleep = builder.comment("Clear rain or thunder status after the player sleeps.").define("ClearAfterSleep", false);
            builder.pop();
        }
    }

    public static class Temperature {
        public static ModConfigSpec.BooleanValue heatStroke;
        public static ModConfigSpec.BooleanValue iceMelt;
        public static ModConfigSpec.BooleanValue snowDown;

        private static void load(ModConfigSpec.Builder builder) {
            builder.push("Temperature");
            iceMelt = builder.comment("Ice or snow layer will melt in warm time.").define("IceAndSnowMelt", false);
            snowDown = builder.comment("It will snow in cold time.").define("IceAndSnow", false);
            heatStroke = builder.comment("Add heat stroke effect in summer noon while in hot biome.").define("HeatStroke", true);
            builder.pop();
        }
    }

    public static class Crop {
        public static ModConfigSpec.BooleanValue enableCrop;
        public static ModConfigSpec.BooleanValue enableCropHumidityControl;
        public static ModConfigSpec.BooleanValue cropHumidityTransition;
        public static ModConfigSpec.IntValue greenHouseMaxDiameter;
        public static ModConfigSpec.IntValue greenHouseMaxHeight;
        public static ModConfigSpec.IntValue darkGreenhouseFailChance;
        public static ModConfigSpec.BooleanValue complexGreenHouseCheck;
        public static ModConfigSpec.BooleanValue registerCropDefaultValue;
        public static ModConfigSpec.BooleanValue forceCompatMode;
        public static ModConfigSpec.BooleanValue simpleGreenHouse;
        public static ModConfigSpec.BooleanValue noCostHumidifier;
        public static ModConfigSpec.BooleanValue useBoxDistance;
        public static ModConfigSpec.IntValue seasonCoreRange;
        public static ModConfigSpec.BooleanValue boneMealFailureMessage;
        public static ModConfigSpec.BooleanValue boneMealConsumeOnFailure;
        public static ModConfigSpec.BooleanValue saveChunkEnvironmentalHumidity;

        private static void load(ModConfigSpec.Builder builder) {
            builder.push("Crop");
            enableCrop = builder.comment("Enable crop season control.").define("EnableSeasonalCrop", true);
            enableCropHumidityControl = builder.comment("Enable crop humidity control.").define("EnableCropHumidityControl", true);
            cropHumidityTransition = builder.comment("If enabled, humidity check will transition smoothly instead of snapping.").define("CropHumidityTransition", true);
            boneMealFailureMessage = builder.comment("Send message to player if failed to use bone meal on crop.").define("BoneMealFailureMessage", true);
            boneMealConsumeOnFailure = builder.comment("Consume anyway if failed to use bone meal on crop.").define("BoneMealConsumeOnFailure", true);
            greenHouseMaxDiameter = builder.comment("The maximum effective diameter of the greenhouse.").defineInRange("GreenHouseMaxDiameter", 32, 5, 256);
            greenHouseMaxHeight = builder.comment("The maximum effective height of the greenhouse.").defineInRange("GreenHouseMaxHeight", 10, 3, 128);
            darkGreenhouseFailChance = builder.comment("Chance that crops fail to grow inside the greenhouse due to insufficient light. Higher values make failure more likely.").defineInRange("LowLightGreenhouseFailChance", 2000, 0, 10000);
            simpleGreenHouse = builder.comment("Build a simple greenhouse without core blocks and humidity modifiers.").define("SimpleGreenHouseMode", false);
            noCostHumidifier = builder.comment("If true, the Humidifier block will no longer consume blocks during conversion.").define("NoCostHumidifier", false);
            seasonCoreRange = builder.comment("The working range of the Season Core block.").defineInRange("SeasonCoreRange", 15, 4, 31);
            complexGreenHouseCheck = builder.comment("Whether to enable complex shape checking.").define("ComplexGreenHouseCheck", true);
            useBoxDistance = builder.comment("Calculate the working range of the greenhouse block by box distance and not Euclidean range.").define("UseBoxDistance", true);
            registerCropDefaultValue = builder.comment("[Deprecated]If a crop is not registered for a season or humid type, default values will be used.").define("RegisterCropDefaultValue", false);
            forceCompatMode = builder.comment("Force all crops to use compatibility mode for growth control, not just those tagged as eclipticseasons:natural_plants.").define("ForceCompatMode", true);
            saveChunkEnvironmentalHumidity = builder.comment("Save environmental humidity modifiers to chunk file.").define("SaveChunkEnvironmentalHumidity", true);
            builder.pop();
        }
    }

    public static class Animal {
        public static ModConfigSpec.BooleanValue enableBreed;
        public static ModConfigSpec.BooleanValue enableBee;
        public static ModConfigSpec.ConfigValue<List<? extends String>> beePollinateSeasons;
        public static ModConfigSpec.ConfigValue<List<? extends String>> beeActiveSeasons;
        public static ModConfigSpec.BooleanValue enableFishing;
        public static ModConfigSpec.ConfigValue<List<? extends String>> fishingSeasons;
        public static ModConfigSpec.BooleanValue lessFishInThunder;
        public static ModConfigSpec.BooleanValue enableCoreWork;

        private static void load(ModConfigSpec.Builder builder) {
            builder.push("Animal");
            enableBreed = builder.comment("Enable seasonal animal breed.").define("EnableSeasonalBreed", false);
            enableBee = builder.comment("Enable seasonal bee behavior, bee would like spring and not like winter and cold.").define("EnableSeasonalBee", false);
            beePollinateSeasons = builder.comment(new String[]{"Seasons in which bees are able to pollinate crops and flowers.", "Default: [SPRING]"}).defineListAllowEmpty("BeePollinateSeasons", () -> List.of(com.teamtea.eclipticseasons.api.constant.solar.Season.SPRING.toString()), com.teamtea.eclipticseasons.api.constant.solar.Season.SPRING::toString, CommonConfig::validSeason);
            beeActiveSeasons = builder.comment(new String[]{"Seasons in which bees are generally active outside the hive.", "Default: [SPRING, SUMMER, AUTUMN]"}).defineListAllowEmpty("BeeActiveSeasons", () -> List.of(com.teamtea.eclipticseasons.api.constant.solar.Season.SPRING.toString(), com.teamtea.eclipticseasons.api.constant.solar.Season.SUMMER.toString(), com.teamtea.eclipticseasons.api.constant.solar.Season.AUTUMN.toString()), com.teamtea.eclipticseasons.api.constant.solar.Season.SPRING::toString, CommonConfig::validSeason);
            enableFishing = builder.comment("Enable seasonal fishing behavior, let enjoy summer.").define("EnableSeasonalFishing", false);
            fishingSeasons = builder.comment(new String[]{"Seasons during which fishing is allowed or more effective.", "Default: [SUMMER]"}).defineListAllowEmpty("FishingSeasons", () -> List.of(com.teamtea.eclipticseasons.api.constant.solar.Season.SUMMER.toString()), com.teamtea.eclipticseasons.api.constant.solar.Season.SUMMER::toString, CommonConfig::validSeason);
            lessFishInThunder = builder.comment("Reduce fish availability during thunderstorms.").define("LessFishInThunder", false);
            enableCoreWork = builder.comment("Season Core affects animals even without a greenhouse.").define("SeasonCoreAffectsAnimals", true);
            builder.pop();
        }
    }

    public static class Map {
        public static ModConfigSpec.BooleanValue changeMapColor;

        private static void load(ModConfigSpec.Builder builder) {
            builder.push("Map");
            changeMapColor = builder.comment("The map color of blocks will change during snow.").define("ChangeMapColor", true);
            builder.pop();
        }
    }

    public static class Snow {
        public static ModConfigSpec.BooleanValue snowyWinter;
        public static ModConfigSpec.BooleanValue snowyTree;
        public static ModConfigSpec.BooleanValue notSnowyNearGlowingBlock;
        public static ModConfigSpec.IntValue notSnowyNearGlowingBlockLevel;
        public static ModConfigSpec.ConfigValue<List<? extends String>> blocksNotSnowy;
        public static ModConfigSpec.ConfigValue<List<? extends List<? extends Serializable>>> biomeSnowLines;
        public static ModConfigSpec.BooleanValue snowInWorld;
        public static ModConfigSpec.BooleanValue forceChunkUpdate;
        public static ModConfigSpec.BooleanValue snowyUnderSnowLike;
        public static ModConfigSpec.BooleanValue stepMelt;

        @SafeVarargs
        private static <T> List<T> of(T ... objs) {
            return Arrays.stream(objs).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        }

        private static boolean testLList(Object o) {
            List innerChildren;
            if (o instanceof List && (innerChildren = (List)o).size() == 2) {
                Object e = innerChildren.get(0);
                if (e instanceof String) {
                    String s = (String)e;
                    try {
                        s = s.startsWith("#") ? s.substring(1, s.length() - 1) : s;
                        ResourceLocation.parse((String)s);
                    }
                    catch (Exception e2) {
                        EclipticSeasons.logger(e2);
                        return false;
                    }
                    return innerChildren.get(1) instanceof Integer;
                }
                return false;
            }
            return false;
        }

        private static void load(ModConfigSpec.Builder builder) {
            builder.push("Snow");
            snowyWinter = builder.comment("If snow falls during cold weather in warm biomes, it will gradually cover all solid blocks and grass.").define("SnowyWinter", true);
            snowyTree = builder.comment("Not just the top layer, now even the leaves below are dusted with frost and snow.").define("SnowyTree", true);
            notSnowyNearGlowingBlock = builder.comment("Snow will not appear in overly bright areas, here define restriction levels.").define("NotSnowyNearGlowingBlock", true);
            notSnowyNearGlowingBlockLevel = builder.comment("Snow will not appear in overly bright areas.").defineInRange("NotSnowyNearGlowingBlockLevel", 10, 1, 15);
            blocksNotSnowy = builder.comment("Specify block IDs here to prevent those blocks from being covered by snow.").defineListAllowEmpty("ForceBlocksNotSnowy", List::of, () -> "", o -> {
                String s;
                return o instanceof String && ResourceLocation.tryParse((String)(s = (String)o)) != null;
            });
            biomeSnowLines = builder.comment("Snow Line Height, define like [\"#c:is_cold/overworld\", 200].").defineListAllowEmpty("BiomeSnowLines", List.of(), List::of, Snow::testLList);
            snowInWorld = builder.comment("Snowfall is now bound to world position rather than only to biomes. This allows for more location-based operations, such as snow sweeping and localized snowfall events.").define("SnowInWorld", false);
            forceChunkUpdate = builder.comment("When SnowInWorld is enabled, update chunk state on load based on differences from previous state records.").define("ForceSnowyChunkUpdate", true);
            snowyUnderSnowLike = builder.comment("When SnowInWorld is enabled, blocks like full blocks under snow layers will have a snowy appearance.").define("SnowCoverUnderBlocks", true);
            stepMelt = builder.comment("When SnowInWorld is enabled, snow may melt when stepped on due to heat.").define("SnowStepMelt", false);
            builder.pop();
        }
    }

    public static class Debug {
        public static ModConfigSpec.BooleanValue logIllegalUse;
        public static ModConfigSpec.BooleanValue notLightAbove;
        public static ModConfigSpec.BooleanValue snowOverlayGlowingBlock;
        public static ModConfigSpec.BooleanValue disableSnowOverlayControlTag;
        public static ModConfigSpec.BooleanValue disableChunkCacheCleaner;
        public static ModConfigSpec.BooleanValue disableUniqueRebindingBiomeTags;
        public static ModConfigSpec.BooleanValue disableIceOrSnowCauldron;

        private static void load(ModConfigSpec.Builder builder) {
            builder.push("Debug");
            logIllegalUse = builder.comment("\u201cEnable logging for illegal function usage.").define("LogIllegalUse", false);
            notLightAbove = builder.comment("Disable snowy blocks beneath light sources with light level 0.").define("NoSnowyUnderLight0", false);
            snowOverlayGlowingBlock = builder.comment("Snow can cover the block which would lights.").define("SnowOverlayGlowingBlock", false);
            disableSnowOverlayControlTag = builder.comment("Set to false to disable tag which stops block from snowy is tagged with \"eclipticseasons:snow_overlay_cannot_survive_on\".").define("DisableSnowOverlayControlTag", false);
            disableChunkCacheCleaner = builder.comment("Disable chunk extra info cache cleanup.").define("DisableChunkCacheCleaner", false);
            disableUniqueRebindingBiomeTags = builder.comment("Disable unique rebinding for biome tags. Note that after disabling, tags may overlap.").define("DisableUniqueBiomeTagsRebinding", false);
            disableIceOrSnowCauldron = builder.comment("Disable cauldron enhancement, they will no longer turn into snow-filled or ice-filled cauldrons when it snows.").define("DisableIceOrSnowCauldron", false);
            builder.pop();
        }
    }
}

