/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.general.advancement;

import com.teamtea.eclipticseasons.common.advancement.ParentNeedCriterion;
import com.teamtea.eclipticseasons.common.advancement.SolarTermsCriterion;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.ESLootTables;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.UsingItemTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ESAdvancementGenerator
implements AdvancementProvider.AdvancementGenerator {
    AdvancementHolder seasons;

    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
        this.seasons = Advancement.Builder.advancement().display((ItemLike)ItemRegistry.calendar_item.get(), (Component)Component.translatable((String)"advancement.eclipticseasons.base"), (Component)Component.translatable((String)"advancement.eclipticseasons.base.desc"), ResourceLocation.parse((String)"minecraft:textures/block/bricks.png"), AdvancementType.TASK, false, false, false).addCriterion("tick", PlayerTrigger.TriggerInstance.tick()).requirements(AdvancementRequirements.Strategy.AND).save(consumer, this.getNameId("main/base"));
        this.seasons = Advancement.Builder.advancement().parent(this.seasons).display((ItemLike)ItemRegistry.bamboo_wind_chimes_item.get(), (Component)Component.translatable((String)"advancement.eclipticseasons.root"), (Component)Component.translatable((String)"advancement.eclipticseasons.root.desc"), null, AdvancementType.TASK, true, true, false).addCriterion("solar_terms", SolarTermsCriterion.TriggerInstance.simple()).requirements(AdvancementRequirements.Strategy.AND).rewards(AdvancementRewards.Builder.loot(ESLootTables.snowless_hometown)).save(consumer, this.getNameId("main/root"));
        AdvancementHolder heatStroke = Advancement.Builder.advancement().parent(this.seasons).display((ItemLike)Items.MAGMA_BLOCK, (Component)Component.translatable((String)"advancement.eclipticseasons.heat_stroke"), (Component)Component.translatable((String)"advancement.eclipticseasons.heat_stroke.desc"), null, AdvancementType.TASK, true, false, true).addCriterion("heat_stroke", SolarTermsCriterion.TriggerInstance.simple2()).requirements(AdvancementRequirements.Strategy.AND).save(consumer, this.getNameId("main/heat_stroke"));
        BlockRegistry.initCopperGrateMap();
        AdvancementHolder green_house = this.buildAdvancementHolder(this.seasons, (ItemLike)ItemRegistry.growth_detector.get(), (Component)Component.translatable((String)"advancement.eclipticseasons.green_house"), (Component)Component.translatable((String)"advancement.eclipticseasons.green_house.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.growth_detector.get()}), consumer, "main/green_house");
        AdvancementHolder greenhouse_core_container = this.buildAdvancementHolder(green_house, (ItemLike)ItemRegistry.greenhouse_core_container_item.get(), (Component)Component.translatable((String)"advancement.eclipticseasons.greenhouse_core_container"), (Component)Component.translatable((String)"advancement.eclipticseasons.greenhouse_core_container.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)BlockRegistry.greenhouse_core_container.get()})}), consumer, "main/greenhouse_core_container");
        AdvancementHolder greenhouse_core = Advancement.Builder.advancement().parent(greenhouse_core_container).display((ItemLike)ItemRegistry.spring_greenhouse_essence_item.get(), (Component)Component.translatable((String)"advancement.eclipticseasons.greenhouse_core"), (Component)Component.translatable((String)"advancement.eclipticseasons.greenhouse_core.desc"), null, AdvancementType.TASK, false, true, false).addCriterion("core_require_spring", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{(Block)BlockRegistry.spring_greenhouse_core.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item())).addCriterion("core_require_summer", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{(Block)BlockRegistry.summer_greenhouse_core.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item())).addCriterion("core_require_autumn", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{(Block)BlockRegistry.autumn_greenhouse_core.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item())).addCriterion("core_require_winter", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{(Block)BlockRegistry.winter_greenhouse_core.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item())).requirements(new AdvancementRequirements(List.of(List.of("core_require_spring", "core_require_summer", "core_require_autumn", "core_require_winter")))).save(consumer, this.getNameId("quests/greenhouse_core"));
        AdvancementHolder copper_grate = this.buildAdvancementHolder(green_house, (ItemLike)Items.COPPER_GRATE, (Component)Component.translatable((String)"advancement.eclipticseasons.copper_grate"), (Component)Component.translatable((String)"advancement.eclipticseasons.copper_grate.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(new ItemLike[]{Blocks.COPPER_GRATE, (ItemLike)BlockRegistry.block_in_wooden_grate_block.get()})}), consumer, "main/copper_grate");
        AdvancementHolder block_in_copper_grate = this.buildAdvancementHolder(copper_grate, (ItemLike)Items.SPONGE, (Component)Component.translatable((String)"advancement.eclipticseasons.block_in_copper_grate"), (Component)Component.translatable((String)"advancement.eclipticseasons.block_in_copper_grate.desc"), "core_require", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(BlockRegistry.getAllChangedGrateBlocks())), (ItemPredicate.Builder)ItemPredicate.Builder.item()), consumer, "main/block_in_copper_grate");
        AdvancementHolder seasonal_prayer_scroll = Advancement.Builder.advancement().parent(this.seasons).display((ItemLike)ItemRegistry.seasonal_prayer_scroll_item.get(), (Component)Component.translatable((String)"advancement.eclipticseasons.seasonal_prayer_scroll"), (Component)Component.translatable((String)"advancement.eclipticseasons.seasonal_prayer_scroll.desc"), null, AdvancementType.TASK, false, true, true).addCriterion("core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.spring_greenhouse_essence_item.get(), (ItemLike)ItemRegistry.summer_greenhouse_essence_item.get(), (ItemLike)ItemRegistry.autumn_greenhouse_essence_item.get(), (ItemLike)ItemRegistry.winter_greenhouse_essence_item.get()})).requirements(AdvancementRequirements.Strategy.AND).save(consumer, this.getNameId("main/seasonal_prayer_scroll"));
        AdvancementHolder decorate_oak_hanging_sign = this.buildAdvancementHolder(seasonal_prayer_scroll, (ItemLike)Items.OAK_HANGING_SIGN, (Component)Component.translatable((String)"advancement.eclipticseasons.decorate_oak_hanging_sign"), (Component)Component.translatable((String)"advancement.eclipticseasons.decorate_oak_hanging_sign.desc"), "core_require", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{(Block)BlockRegistry.season_quest_wall_hanging_sign.get(), (Block)BlockRegistry.season_quest_ceiling_hanging_sign.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item()), consumer, "main/decorate_oak_hanging_sign");
        this.seasons = Advancement.Builder.advancement().parent(this.seasons).display((ItemLike)ItemRegistry.pinwheel_lime_item.get(), (Component)Component.translatable((String)"advancement.eclipticseasons.quest"), (Component)Component.translatable((String)"advancement.eclipticseasons.quest.desc"), null, AdvancementType.TASK, false, false, false).addCriterion("tick", PlayerTrigger.TriggerInstance.tick()).requirements(AdvancementRequirements.Strategy.AND).save(consumer, this.getNameId("main/quest"));
        this.buildSpring(consumer);
        this.buildSummer(consumer);
        this.buildAutumn(consumer);
        this.buildWinter(consumer);
    }

    private void buildSpring(Consumer<AdvancementHolder> consumer) {
        AdvancementHolder spring_start = this.buildAdvancementHolder(this.seasons, (ItemLike)Items.WHEAT_SEEDS, (Component)Component.translatable((String)"advancement.eclipticseasons.spring_start"), (Component)Component.translatable((String)"advancement.eclipticseasons.spring_start.desc"), "core_require", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location(), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.WHEAT_SEEDS})), consumer, "quests/spring_start");
        AdvancementHolder spring_harvest = this.buildAdvancementHolder(spring_start, (ItemLike)Items.WHEAT, (Component)Component.translatable((String)"advancement.eclipticseasons.spring_harvest"), (Component)Component.translatable((String)"advancement.eclipticseasons.spring_harvest.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT}), consumer, "quests/spring_harvest");
        AdvancementHolder spring_feed = Advancement.Builder.advancement().parent(spring_harvest).display((ItemLike)Items.WHITE_WOOL, (Component)Component.translatable((String)"advancement.eclipticseasons.spring_feed"), (Component)Component.translatable((String)"advancement.eclipticseasons.spring_feed.desc"), null, AdvancementType.TASK, false, true, false).addCriterion("core_require_sheep", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.SHEEP_FOOD), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.SHEEP))))).addCriterion("core_require_cow", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.COW_FOOD), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.COW))))).addCriterion("core_require_chicken", PlayerInteractTrigger.TriggerInstance.itemUsedOnEntity((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CHICKEN_FOOD), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(EntityType.CHICKEN))))).addCriterion("parent", ParentNeedCriterion.TriggerInstance.simple(spring_harvest)).requirements(new AdvancementRequirements(List.of(List.of("core_require_sheep", "core_require_cow", "core_require_chicken"), List.of("parent")))).save(consumer, this.getNameId("quests/spring_feed"));
        AdvancementHolder spring_seed = this.buildAdvancementHolder(spring_feed, (ItemLike)Items.WHEAT_SEEDS, (Component)Component.translatable((String)"advancement.eclipticseasons.spring_seed"), (Component)Component.translatable((String)"advancement.eclipticseasons.spring_seed.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.WHEAT_SEEDS}), consumer, "quests/spring_seed");
        AdvancementHolder spring_bread = this.buildAdvancementHolder(spring_seed, (ItemLike)Items.BREAD, (Component)Component.translatable((String)"advancement.eclipticseasons.spring_bread"), (Component)Component.translatable((String)"advancement.eclipticseasons.spring_bread.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BREAD}), consumer, "quests/spring_bread");
        AdvancementHolder spring_hay = this.buildAdvancementHolder(spring_bread, (ItemLike)Items.HAY_BLOCK, (Component)Component.translatable((String)"advancement.eclipticseasons.spring_hay"), (Component)Component.translatable((String)"advancement.eclipticseasons.spring_hay.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.HAY_BLOCK}), consumer, "quests/spring_hay", ESLootTables.spring_greenhouse_essence);
    }

    private void buildSummer(Consumer<AdvancementHolder> consumer) {
        AdvancementHolder summer_start = this.buildAdvancementHolder(this.seasons, (ItemLike)Items.MELON_SEEDS, (Component)Component.translatable((String)"advancement.eclipticseasons.summer_start"), (Component)Component.translatable((String)"advancement.eclipticseasons.summer_start.desc"), "core_require", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location(), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.MELON_SEEDS})), consumer, "quests/summer_start");
        AdvancementHolder summer_harvest = this.buildAdvancementHolder(summer_start, (ItemLike)Items.MELON, (Component)Component.translatable((String)"advancement.eclipticseasons.summer_harvest"), (Component)Component.translatable((String)"advancement.eclipticseasons.summer_harvest.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MELON}), consumer, "quests/summer_harvest");
        AdvancementHolder summer_melon_slice = this.buildAdvancementHolder(summer_harvest, (ItemLike)Items.MELON_SLICE, (Component)Component.translatable((String)"advancement.eclipticseasons.summer_melon_slice"), (Component)Component.translatable((String)"advancement.eclipticseasons.summer_melon_slice.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MELON_SLICE}), consumer, "quests/summer_melon_slice");
        AdvancementHolder summer_seed = this.buildAdvancementHolder(summer_melon_slice, (ItemLike)Items.MELON_SEEDS, (Component)Component.translatable((String)"advancement.eclipticseasons.summer_seed"), (Component)Component.translatable((String)"advancement.eclipticseasons.summer_seed.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MELON_SEEDS}), consumer, "quests/summer_seed");
        AdvancementHolder summer_glistering_melon_slice = this.buildAdvancementHolder(summer_seed, (ItemLike)Items.GOLD_NUGGET, (Component)Component.translatable((String)"advancement.eclipticseasons.summer_glistering_melon_slice"), (Component)Component.translatable((String)"advancement.eclipticseasons.summer_glistering_melon_slice.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GOLD_NUGGET}), consumer, "quests/summer_glistering_melon_slice");
        AdvancementHolder summer_eat_glistering_melon_slice = this.buildAdvancementHolder(summer_glistering_melon_slice, (ItemLike)Items.GLISTERING_MELON_SLICE, (Component)Component.translatable((String)"advancement.eclipticseasons.summer_eat_glistering_melon_slice"), (Component)Component.translatable((String)"advancement.eclipticseasons.summer_eat_glistering_melon_slice.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GLISTERING_MELON_SLICE}), consumer, "quests/summer_eat_glistering_melon_slice", ESLootTables.summer_greenhouse_essence);
    }

    private void buildAutumn(Consumer<AdvancementHolder> consumer) {
        AdvancementHolder autumn_start = this.buildAdvancementHolder(this.seasons, (ItemLike)Items.PUMPKIN_SEEDS, (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_start"), (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_start.desc"), "core_require", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location(), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.PUMPKIN_SEEDS})), consumer, "quests/autumn_start");
        AdvancementHolder autumn_harvest = this.buildAdvancementHolder(autumn_start, (ItemLike)Items.PUMPKIN, (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_harvest"), (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_harvest.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PUMPKIN}), consumer, "quests/autumn_harvest");
        AdvancementHolder autumn_seed = this.buildAdvancementHolder(autumn_harvest, (ItemLike)Items.PUMPKIN_SEEDS, (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_seed"), (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_seed.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PUMPKIN_SEEDS}), consumer, "quests/autumn_seed");
        AdvancementHolder autumn_carved_pumpkin = this.buildAdvancementHolder(autumn_seed, (ItemLike)Items.CARVED_PUMPKIN, (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_carved_pumpkin"), (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_carved_pumpkin.desc"), "core_require", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{Blocks.CARVED_PUMPKIN})), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR)), consumer, "quests/autumn_carved_pumpkin");
        AdvancementHolder autumn_jack_o_lantern = this.buildAdvancementHolder(autumn_carved_pumpkin, (ItemLike)Items.JACK_O_LANTERN, (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_jack_o_lantern"), (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_jack_o_lantern.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.JACK_O_LANTERN}), consumer, "quests/autumn_jack_o_lantern");
        AdvancementHolder autumn_pumpkin_pie = this.buildAdvancementHolder(autumn_jack_o_lantern, (ItemLike)Items.PUMPKIN_PIE, (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_pumpkin_pie"), (Component)Component.translatable((String)"advancement.eclipticseasons.autumn_pumpkin_pie.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.PUMPKIN_PIE}), consumer, "quests/autumn_pumpkin_pie", ESLootTables.autumn_greenhouse_essence);
    }

    private void buildWinter(Consumer<AdvancementHolder> consumer) {
        AdvancementHolder winter_start = this.buildAdvancementHolder(this.seasons, (ItemLike)ItemRegistry.broom.get(), (Component)Component.translatable((String)"advancement.eclipticseasons.winter_start"), (Component)Component.translatable((String)"advancement.eclipticseasons.winter_start.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.broom.get()}), consumer, "quests/winter_start");
        AdvancementHolder winter_harvest = this.buildAdvancementHolder(winter_start, (ItemLike)Items.POWDER_SNOW_BUCKET, (Component)Component.translatable((String)"advancement.eclipticseasons.winter_harvest"), (Component)Component.translatable((String)"advancement.eclipticseasons.winter_harvest.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.POWDER_SNOW_BUCKET}), consumer, "quests/winter_harvest");
        AdvancementHolder winter_campfire = this.buildAdvancementHolder(winter_harvest, (ItemLike)Items.CAMPFIRE, (Component)Component.translatable((String)"advancement.eclipticseasons.winter_campfire"), (Component)Component.translatable((String)"advancement.eclipticseasons.winter_campfire.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.CAMPFIRE}), consumer, "quests/winter_campfire");
        AdvancementHolder winter_milk = this.buildAdvancementHolder(winter_campfire, (ItemLike)Items.MILK_BUCKET, (Component)Component.translatable((String)"advancement.eclipticseasons.winter_milk"), (Component)Component.translatable((String)"advancement.eclipticseasons.winter_milk.desc"), "core_require", UsingItemTrigger.TriggerInstance.lookingAt((EntityPredicate.Builder)EntityPredicate.Builder.entity(), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.MILK_BUCKET})), consumer, "quests/winter_milk");
        AdvancementHolder winter_carpet = this.buildAdvancementHolder(winter_milk, (ItemLike)Items.WHITE_CARPET, (Component)Component.translatable((String)"advancement.eclipticseasons.winter_carpet"), (Component)Component.translatable((String)"advancement.eclipticseasons.winter_carpet.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(ItemTags.WOOL_CARPETS)}), consumer, "quests/winter_carpet");
        AdvancementHolder winter_cake = this.buildAdvancementHolder(winter_carpet, (ItemLike)Items.CAKE, (Component)Component.translatable((String)"advancement.eclipticseasons.winter_cake"), (Component)Component.translatable((String)"advancement.eclipticseasons.winter_cake.desc"), "core_require", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.CAKE}), consumer, "quests/winter_cake", ESLootTables.winter_greenhouse_essence);
    }

    public AdvancementHolder buildAdvancementHolder(AdvancementHolder parent, ItemLike icon, Component tittle, Component desc, String criterionKey, Criterion<?> criterion, Consumer<AdvancementHolder> consumer, String id) {
        return this.buildAdvancementHolder(parent, icon, tittle, desc, criterionKey, criterion, consumer, id, null);
    }

    public AdvancementHolder buildAdvancementHolder(AdvancementHolder parent, ItemLike icon, Component tittle, Component desc, String criterionKey, Criterion<?> criterion, Consumer<AdvancementHolder> consumer, String id, ResourceKey<LootTable> lootTable) {
        Advancement.Builder advancement = Advancement.Builder.advancement();
        if (parent != null) {
            advancement = advancement.parent(parent);
            if (parent != this.seasons) {
                advancement = advancement.addCriterion("parent_need", ParentNeedCriterion.TriggerInstance.simple(parent));
            }
        }
        if (lootTable != null) {
            advancement = advancement.rewards(AdvancementRewards.Builder.loot(lootTable));
        }
        return advancement.display(icon, tittle, desc, null, AdvancementType.TASK, false, true, false).addCriterion(criterionKey, criterion).requirements(AdvancementRequirements.Strategy.AND).save(consumer, this.getNameId(id));
    }

    private String getNameId(String id) {
        return "eclipticseasons:" + id;
    }
}

