/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.general.loot;

import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class EclipticSeasonsBlockLootTables
extends BlockLootSubProvider {
    public EclipticSeasonsBlockLootTables(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected Iterable<Block> getKnownBlocks() {
        return this.map.entrySet().stream().map(e -> BuiltInRegistries.BLOCK.stream().filter(block -> block.getLootTable().equals(e.getKey())).findFirst().get()).toList();
    }

    protected void dropSelfWithContents(Set<Block> blocks) {
        for (Block block : blocks) {
            this.add(block, this.createSingleItemTable((ItemLike)block));
        }
    }

    protected void generate() {
        Set<Block> blocks = BuiltInRegistries.BLOCK.stream().filter(block -> "eclipticseasons".equals(BuiltInRegistries.BLOCK.getKey(block).getNamespace())).filter(block -> !block.getLootTable().equals(BuiltInLootTables.EMPTY)).filter(block -> block.asItem() != Items.AIR).collect(Collectors.toSet());
        this.dropSelfWithContents(blocks);
        this.dropWhenSilkTouch((Block)BlockRegistry.greenhouse_core_container.get());
        this.createCoreDrop((Block)BlockRegistry.spring_greenhouse_core.get(), (Item)ItemRegistry.spring_greenhouse_essence_item.get());
        this.createCoreDrop((Block)BlockRegistry.summer_greenhouse_core.get(), (Item)ItemRegistry.summer_greenhouse_essence_item.get());
        this.createCoreDrop((Block)BlockRegistry.autumn_greenhouse_core.get(), (Item)ItemRegistry.autumn_greenhouse_essence_item.get());
        this.createCoreDrop((Block)BlockRegistry.winter_greenhouse_core.get(), (Item)ItemRegistry.winter_greenhouse_essence_item.get());
        this.dropOther((Block)BlockRegistry.block_in_copper_grate_block.get(), (ItemLike)Blocks.COPPER_GRATE);
        this.dropOther((Block)BlockRegistry.block_in_exposed_copper_grate_block.get(), (ItemLike)Blocks.EXPOSED_COPPER_GRATE);
        this.dropOther((Block)BlockRegistry.block_in_weathered_copper_grate_block.get(), (ItemLike)Blocks.WEATHERED_COPPER_GRATE);
        this.dropOther((Block)BlockRegistry.block_in_oxidized_copper_grate_block.get(), (ItemLike)Blocks.OXIDIZED_COPPER_GRATE);
        this.dropOther((Block)BlockRegistry.block_in_waxed_copper_grate_block.get(), (ItemLike)Blocks.WAXED_COPPER_GRATE);
        this.dropOther((Block)BlockRegistry.block_in_waxed_exposed_copper_grate_block.get(), (ItemLike)Blocks.WAXED_EXPOSED_COPPER_GRATE);
        this.dropOther((Block)BlockRegistry.block_in_waxed_weathered_copper_grate_block.get(), (ItemLike)Blocks.WAXED_WEATHERED_COPPER_GRATE);
        this.dropOther((Block)BlockRegistry.block_in_waxed_oxidized_copper_grate_block.get(), (ItemLike)Blocks.WAXED_OXIDIZED_COPPER_GRATE);
        this.dropOther((Block)BlockRegistry.snow_cauldron.get(), (ItemLike)Blocks.CAULDRON);
        this.dropOther((Block)BlockRegistry.ice_cauldron.get(), (ItemLike)Blocks.CAULDRON);
    }

    protected void createCoreDrop(Block pBlock, Item pItem) {
        this.add(pBlock, this.createSilkTouchDispatchTable(pBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)pItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))));
    }
}

