/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.general.model;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.biome.Rainfall;
import com.teamtea.eclipticseasons.api.constant.biome.Temperature;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ESItemModelProvider
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";

    public ESItemModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    private String blockName(BlockItem blockItem) {
        return BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()).getPath();
    }

    protected void registerModels() {
        this.addSimple((Item)ItemRegistry.calendar_item.value());
        this.addSimple((Item)ItemRegistry.wind_chimes_item.value());
        this.addSimple((Item)ItemRegistry.paper_wind_chimes_item.value());
        this.addSimple((Item)ItemRegistry.bamboo_wind_chimes_item.value());
        this.addSimple((ItemLike)ItemRegistry.pinwheel_blue_item.value(), "pinwheel_blue_item");
        this.addSimple((ItemLike)ItemRegistry.pinwheel_lime_item.value(), "pinwheel_lime_item");
        this.addSimple((ItemLike)ItemRegistry.pinwheel_orange_item.value(), "pinwheel_orange_item");
        this.addSimple((Item)ItemRegistry.broom.value());
        this.addSimple((Item)ItemRegistry.ice_wand.value());
        this.addSimple((Item)ItemRegistry.seasonal_prayer_scroll_item.value());
        this.addSimple((Item)ItemRegistry.growth_detector.value());
        this.addSimple((Item)ItemRegistry.snowless_hometown.value());
        this.addStandProperties((Item)ItemRegistry.hygrometer.get(), Rainfall.collectValues().length);
        this.addStandProperties((Item)ItemRegistry.hyetometer.get(), Humidity.collectValues().length);
        this.addStandProperties((Item)ItemRegistry.thermometer.get(), Temperature.collectValues().length);
        this.withExistingParent(this.itemName((ItemLike)ItemRegistry.spring_greenhouse_essence_item.get()), this.resourceItem("empty"));
        this.withExistingParent(this.itemName((ItemLike)ItemRegistry.summer_greenhouse_essence_item.get()), this.resourceItem("empty"));
        this.withExistingParent(this.itemName((ItemLike)ItemRegistry.autumn_greenhouse_essence_item.get()), this.resourceItem("empty"));
        this.withExistingParent(this.itemName((ItemLike)ItemRegistry.winter_greenhouse_essence_item.get()), this.resourceItem("empty"));
        this.withExistingParent(this.resourceItem(ItemRegistry.block_in_wooden_grate_block_item.getId().getPath()).getPath(), this.resourceBlock(ItemRegistry.block_in_wooden_grate_block_item.getId().getPath()));
    }

    public void addSimple(Item item) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName((ItemLike)item), ResourceLocation.withDefaultNamespace((String)GENERATED))).texture("layer0", this.resourceItem(this.itemName((ItemLike)item)));
    }

    public void addSimple(ItemLike item, String texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), ResourceLocation.withDefaultNamespace((String)GENERATED))).texture("layer0", this.resourceItem(texture));
    }

    public void addSimple(String item, String texture) {
        ((ItemModelBuilder)this.withExistingParent(this.resourceItem(item).getPath(), ResourceLocation.withDefaultNamespace((String)GENERATED))).texture("layer0", this.resourceItem(texture));
    }

    private String itemName(ItemLike item) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath();
    }

    public ResourceLocation resourceItem(String path) {
        return EclipticSeasons.rl("item/" + path);
    }

    public void addStandProperties(Item item, int length) {
        ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        for (int i = 0; i < length; ++i) {
            String name = itemKey.getPath() + "_stage_" + i;
            this.addSimple(name, name);
        }
        ItemModelBuilder itemModelBuilder = (ItemModelBuilder)this.withExistingParent(this.itemName((ItemLike)item), itemKey.withSuffix("_stage_0"));
        for (int i = 0; i < length; ++i) {
            itemModelBuilder.override().predicate(itemKey, (float)i * (1.0f / ((float)length - 1.0f))).model((ModelFile)new ModelFile.ExistingModelFile(this.resourceItem(itemKey.getPath() + "_stage_" + i), this.existingFileHelper)).end();
        }
    }

    public ResourceLocation resourceBlock(String path) {
        return EclipticSeasons.rl("block/" + path);
    }
}

