/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.general.tag;

import com.teamtea.eclipticseasons.api.constant.crop.CropHumidityType;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonType;
import com.teamtea.eclipticseasons.api.constant.tag.ESItemTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public final class ESItemTagProvider
extends ItemTagsProvider {
    public ESItemTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> providerCompletableFuture, CompletableFuture<TagsProvider.TagLookup<Block>> tagLookupCompletableFuture) {
        super(packOutput, providerCompletableFuture, tagLookupCompletableFuture);
    }

    public String getName() {
        return "ES Item Tags";
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        this.tag(CropSeasonType.SUMMER.getTag()).add((Object[])new Item[]{Items.MELON_SEEDS, Items.COCOA_BEANS, Items.CACTUS});
        this.tag(CropSeasonType.AUTUMN.getTag()).add((Object)Items.PUMPKIN_SEEDS);
        this.tag(CropSeasonType.SP_AU.getTag()).add((Object[])new Item[]{Items.POTATO, Items.BEETROOT_SEEDS, Items.CARROT});
        this.tag(CropSeasonType.SP_SU_AU.getTag()).add((Object[])new Item[]{Items.KELP, Items.TORCHFLOWER_SEEDS});
        this.tag(CropSeasonType.SP_SU.getTag()).add((Object)Items.WHEAT_SEEDS).add((Object)Items.SUGAR_CANE);
        this.tag(CropSeasonType.ALL.getTag()).add((Object)Items.GLOW_BERRIES);
        this.tag(CropSeasonType.SP_WI.getTag()).add((Object)Items.SWEET_BERRIES);
        this.tag(CropSeasonType.SPRING.getTag()).add((Object)Items.BAMBOO);
        this.tag(CropHumidityType.DRY_AVERAGE.getTag()).add((Object)Items.CACTUS);
        this.tag(CropHumidityType.DRY_MOIST.getTag()).add((Object)Items.SWEET_BERRIES);
        this.tag(CropHumidityType.DRY_HUMID.getTag()).add((Object)Items.MELON_SEEDS);
        this.tag(CropHumidityType.AVERAGE_HUMID.getTag()).add((Object[])new Item[]{Items.GLOW_BERRIES, Items.SUGAR_CANE});
        this.tag(CropHumidityType.AVERAGE_MOIST.getTag()).add((Object[])new Item[]{Items.WHEAT_SEEDS, Items.CARROT, Items.BEETROOT_SEEDS, Items.POTATO, Items.PUMPKIN_SEEDS});
        this.tag(CropHumidityType.AVERAGE_MOIST.getTag()).add((Object[])new Item[]{Items.COCOA_BEANS, Items.KELP, Items.TORCHFLOWER_SEEDS});
        this.tag(CropHumidityType.MOIST_HUMID.getTag()).add((Object)Items.BAMBOO).add((Object[])new Item[]{Items.BROWN_MUSHROOM, Items.RED_MUSHROOM});
        for (CropSeasonType cropSeasonType : CropSeasonType.collectValues()) {
            this.tag(cropSeasonType.getTag());
        }
        for (Enum enum_ : CropHumidityType.collectValues()) {
            this.tag(((CropHumidityType)enum_).getTag());
        }
        this.tag(CropHumidityType.AVERAGE_MOIST.getTag()).addOptional(this.fd_rl("tomato_seeds")).addOptional(this.fd_rl("cabbage_seeds")).addOptional(this.fd_rl("onion"));
        this.tag(CropHumidityType.MOIST_HUMID.getTag()).addOptional(this.fd_rl("rice")).addOptional(this.fd_rl("brown_mushroom_colony")).addOptional(this.fd_rl("red_mushroom_colony"));
        this.tag(ESItemTags.COOLING_ITEMS).add((Object[])new Item[]{Items.SNOWBALL, Items.SNOW_BLOCK, Items.ICE, Items.BLUE_ICE, Items.PACKED_ICE});
        this.tag(ESItemTags.HEAT_PROTECTIVE_HELMETS);
        this.tag(ESItemTags.UNAFFECTED_BY_SEASONS);
        this.tag(ESItemTags.UNAFFECTED_BY_HUMIDITY);
    }

    public ResourceLocation srl(String croptopia, String name) {
        return ResourceLocation.fromNamespaceAndPath((String)croptopia, (String)name);
    }

    public ResourceLocation fd_rl(String name) {
        return this.srl("farmersdelight", name);
    }
}

