/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.common.block;

import com.teamtea.eclipticseasons.api.constant.tag.EclipticBlockTags;
import com.teamtea.eclipticseasons.api.data.craft.WetterStructure;
import com.teamtea.eclipticseasons.api.misc.CustomRandomTick;
import com.teamtea.eclipticseasons.api.misc.IBlockStateFlagger;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.crop.NaturalPlantHandler;
import com.teamtea.eclipticseasons.common.hook.ESEventHook;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class MixinBlockStateBase
implements CustomRandomTick {
    @Shadow
    private boolean isRandomlyTicking;
    @Unique
    public int eclipticseasons$tickType = 0;
    @Unique
    public List<WetterStructure> eclipticseasons$wetterStructures = null;

    @Shadow
    public abstract boolean is(TagKey<Block> var1);

    @Shadow
    public abstract boolean isRandomlyTicking();

    @Shadow
    protected abstract BlockState asState();

    @Inject(method={"initCache"}, at={@At(value="TAIL")})
    private void eclipticseasons$initCache(CallbackInfo ci) {
        MixinBlockStateBase mixinBlockStateBase = this;
        if (mixinBlockStateBase instanceof IBlockStateFlagger) {
            IBlockStateFlagger iBlockStateFlagger = (IBlockStateFlagger)((Object)mixinBlockStateBase);
            iBlockStateFlagger.setBlockTypeFlag(-1);
            iBlockStateFlagger.setForceTickControl(this.is(EclipticBlockTags.NATURAL_PLANTS));
            if (!this.isRandomlyTicking() && this.is(EclipticBlockTags.VOLATILE)) {
                this.isRandomlyTicking = true;
            }
        }
        if ((mixinBlockStateBase = this) instanceof CustomRandomTick) {
            MixinBlockStateBase customRandomTick = mixinBlockStateBase;
            customRandomTick.eclipticseasons$reset();
        }
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void eclipticseasons$randomTick(ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        boolean canCropGrow;
        IBlockStateFlagger iBlockStateFlagger;
        this.eclipticseasons$tick(this.asState(), level, pos);
        MixinBlockStateBase mixinBlockStateBase = this;
        if (mixinBlockStateBase instanceof IBlockStateFlagger && ((iBlockStateFlagger = (IBlockStateFlagger)((Object)mixinBlockStateBase)).forceTickControl() || CommonConfig.isForceCropCompatMode()) && !(canCropGrow = ESEventHook.canExtraCropGrow((Level)level, pos, iBlockStateFlagger.es$asState(), true))) {
            ci.cancel();
        }
    }

    @Override
    public void eclipticseasons$tick(BlockState state, ServerLevel worldIn, BlockPos pos) {
        switch (this.eclipticseasons$tickType) {
            case 1: {
                return;
            }
            case 2: {
                CropGrowthHandler.handleRandomTick(worldIn, pos, state, this.eclipticseasons$wetterStructures);
                break;
            }
            case 3: {
                NaturalPlantHandler.tickBlock(worldIn, pos, state);
                break;
            }
            case 4: {
                CropGrowthHandler.handleRandomTick(worldIn, pos, state, this.eclipticseasons$wetterStructures);
                NaturalPlantHandler.tickBlock(worldIn, pos, state);
                break;
            }
            default: {
                List<WetterStructure> wetterStructures = CropGrowthHandler.validTick(state);
                this.eclipticseasons$tickType = wetterStructures.isEmpty() ? 1 : 2;
                this.eclipticseasons$wetterStructures = wetterStructures;
                if (NaturalPlantHandler.shouldTick(state)) {
                    this.eclipticseasons$tickType = this.eclipticseasons$tickType == 1 ? 3 : 4;
                }
                this.eclipticseasons$tick(state, worldIn, pos);
            }
        }
    }

    @Override
    public void eclipticseasons$reset() {
        this.eclipticseasons$tickType = 0;
        this.eclipticseasons$wetterStructures = null;
    }

    @Override
    public int eclipticseasons$getType() {
        return this.eclipticseasons$tickType;
    }
}

