/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.common.worldgen;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.registry.AttachmentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SurfaceSystem.class})
public abstract class MixinSurfaceSystem {
    @Inject(at={@At(value="HEAD")}, method={"buildSurface"})
    public void eclipticseasons$buildSurface_cacheBiome_init(RandomState randomState, BiomeManager biomeManager, Registry<Biome> biomes, boolean useLegacyRandomSource, WorldGenerationContext context, ChunkAccess chunk, NoiseChunk noiseChunk, SurfaceRules.RuleSource ruleSource, CallbackInfo ci, @Share(value="biomeArrays") LocalRef<int[]> biomeHolderLocalRef, @Share(value="intCounter") LocalIntRef localIntRef, @Share(value="signal") LocalIntRef signal) {
        biomeHolderLocalRef.set((Object)new int[256]);
        localIntRef.set(0);
        signal.set(-1);
    }

    @Inject(at={@At(value="INVOKE_ASSIGN", shift=At.Shift.AFTER, target="Lnet/minecraft/world/level/biome/BiomeManager;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;")}, method={"buildSurface"})
    public void eclipticseasons$buildSurface_cacheBiome(RandomState randomState, BiomeManager biomeManager, Registry<Biome> biomes, boolean useLegacyRandomSource, WorldGenerationContext context, ChunkAccess chunk, NoiseChunk noiseChunk, SurfaceRules.RuleSource ruleSource, CallbackInfo ci, @Local Holder<Biome> biomeHolder, @Local(ordinal=1) BlockPos.MutableBlockPos blockPos, @Share(value="biomeArrays") LocalRef<int[]> biomeHolderLocalRef, @Share(value="intCounter") LocalIntRef localIntRef, @Share(value="signal") LocalIntRef signal) {
        int i = MapChecker.biomeToId(biomes, (Biome)biomeHolder.value());
        if (i > -1 && i < biomes.size()) {
            ((int[])biomeHolderLocalRef.get())[(blockPos.getX() & 0xF) * 16 + (blockPos.getZ() & 0xF)] = i;
            localIntRef.set(localIntRef.get() + 1);
            if (MapChecker.isSmallBiome(biomeHolder)) {
                signal.set(-2);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"buildSurface"})
    public void eclipticseasons$buildSurface_cacheBiome_end(RandomState randomState, BiomeManager biomeManager, Registry<Biome> biomes, boolean useLegacyRandomSource, WorldGenerationContext context, ChunkAccess chunk, NoiseChunk noiseChunk, SurfaceRules.RuleSource ruleSource, CallbackInfo ci, @Share(value="biomeArrays") LocalRef<int[]> biomeHolderLocalRef, @Share(value="intCounter") LocalIntRef localIntRef, @Share(value="signal") LocalIntRef signal) {
        if (localIntRef.get() == 256) {
            chunk.setData(AttachmentRegistry.BIOME_HOLDER, (Object)new BiomeHolder((int[])biomeHolderLocalRef.get(), true, signal.get()));
        }
    }
}

