/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.compat.sodium;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.misc.client.IExtraRendererContextOwner;
import com.teamtea.eclipticseasons.api.misc.client.IMapSlice;
import com.teamtea.eclipticseasons.api.misc.client.ISnowyGetter;
import com.teamtea.eclipticseasons.client.core.ExtraRendererContext;
import com.teamtea.eclipticseasons.common.core.map.BiomeHolder;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.map.SnowyRemover;
import com.teamtea.eclipticseasons.common.core.snow.SnowyStatusKeeper;
import java.util.Arrays;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelSlice.class})
public abstract class MixinLevelSlice
implements IMapSlice,
IExtraRendererContextOwner {
    @Unique
    private static final int MAP_BLOCK_COUNT = 256;
    @Unique
    private static int MAP_ARRAY_SIZE;
    @Unique
    private int[][] HEIGHT_MAP;
    @Unique
    private int[][] SOLID_HEIGHT_MAP;
    @Unique
    private int[][] BIOME_MAP;
    @Unique
    private int[][] SNOWY_MAP;
    @Unique
    private SnowyStatusKeeper[] SNOWY_STATUS_MAP;
    @Shadow
    private int originBlockX;
    @Shadow
    @Final
    private ClientLevel level;
    @Shadow
    private int originBlockZ;
    @Shadow
    @Final
    private static int SECTION_ARRAY_LENGTH;
    @Shadow
    private BoundingBox volume;
    @Shadow
    @Final
    private static int NEIGHBOR_CHUNK_RADIUS;
    @Shadow
    private int originBlockY;
    @Shadow
    @Final
    @Nullable
    private DataLayer[][] lightArrays;
    @Unique
    private BlockPos.MutableBlockPos eclipticseasons$checkPos = new BlockPos.MutableBlockPos();
    @Unique
    private ExtraRendererContext eclipticseasons$rendererHolder = new ExtraRendererContext();

    @Shadow
    public static int getLocalSectionIndex(int sectionX, int sectionY, int sectionZ) {
        return 0;
    }

    @Inject(remap=false, method={"<clinit>"}, at={@At(value="TAIL")})
    private static void eclipticseasons$clinit(CallbackInfo ci) {
        MAP_ARRAY_SIZE = SECTION_ARRAY_LENGTH * SECTION_ARRAY_LENGTH;
    }

    @Inject(remap=false, method={"<init>"}, at={@At(value="TAIL")})
    private void eclipticseasons$init(ClientLevel level, CallbackInfo ci) {
        this.HEIGHT_MAP = new int[MAP_ARRAY_SIZE][256];
        this.SOLID_HEIGHT_MAP = new int[MAP_ARRAY_SIZE][256];
        this.BIOME_MAP = new int[MAP_ARRAY_SIZE][256];
        this.SNOWY_MAP = new int[MAP_ARRAY_SIZE][256];
        this.SNOWY_STATUS_MAP = new SnowyStatusKeeper[MAP_ARRAY_SIZE];
    }

    @Inject(remap=false, method={"copyData"}, at={@At(value="TAIL")})
    private void eclipticseasons$copySectionData(ChunkRenderContext context, CallbackInfo ci) {
        if (MapChecker.isValidDimension((Level)this.level)) {
            int maxH = this.level.getMaxBuildHeight();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int sectionX = 0; sectionX < SECTION_ARRAY_LENGTH; ++sectionX) {
                for (int sectionZ = 0; sectionZ < SECTION_ARRAY_LENGTH; ++sectionZ) {
                    ISnowyGetter snowyGetter = (ISnowyGetter)context.getSections()[MixinLevelSlice.getLocalSectionIndex(sectionX, 0, sectionZ)];
                    SnowyRemover snowyRemover = snowyGetter.getSnowyRemover();
                    BiomeHolder biomeHolder = snowyGetter.getBiomeHolder();
                    int localSectionIndex = MixinLevelSlice.eclipticseasons$getLocalSectionIndex(sectionX, sectionZ);
                    int[] heights = this.HEIGHT_MAP[localSectionIndex];
                    int[] solidHeights = this.SOLID_HEIGHT_MAP[localSectionIndex];
                    int[] biomes = this.BIOME_MAP[localSectionIndex];
                    int[] snowys = this.SNOWY_MAP[localSectionIndex];
                    this.SNOWY_STATUS_MAP[localSectionIndex] = snowyGetter.getSnowyStatusKeeper();
                    int startX = this.originBlockX + sectionX * 16;
                    int startZ = this.originBlockZ + sectionZ * 16;
                    mutableBlockPos.setX(startX);
                    mutableBlockPos.setZ(startZ);
                    ChunkInfoMap chunkMap = snowyGetter.getChunkInfoMap();
                    if (chunkMap != null) {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                int biomeId;
                                int index = x * 16 + z;
                                mutableBlockPos.setX(startX + x);
                                mutableBlockPos.setZ(startZ + z);
                                int y = chunkMap.getHeight((BlockPos)mutableBlockPos);
                                heights[index] = y > chunkMap.getMinY() ? y : MapChecker.getHeight((Level)this.level, (BlockPos)mutableBlockPos);
                                mutableBlockPos.setY(heights[index] + 1);
                                if (mutableBlockPos.getY() > maxH) {
                                    mutableBlockPos.setY(this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, mutableBlockPos.getX(), mutableBlockPos.getZ()));
                                }
                                biomes[index] = (biomeId = biomeHolder.getBiomeId((BlockPos)mutableBlockPos)) > -1 ? biomeId : MapChecker.biomeToId((Level)this.level, (Biome)MapChecker.getUnCachedSurfaceBiome((Level)this.level, (BlockPos)mutableBlockPos).value());
                                snowys[index] = snowyRemover.blockWatcher()[x][z];
                                solidHeights[index] = snowyGetter.getSolidHeightMap().getHighestTaken(x, z);
                            }
                        }
                        continue;
                    }
                    EclipticSeasons.logger("Warning, now try create slice for invalid level", this.level, context.getOrigin());
                }
            }
        }
    }

    @Unique
    private static int eclipticseasons$getLocalSectionIndex(int sectionX, int sectionZ) {
        return sectionZ * SECTION_ARRAY_LENGTH + sectionX;
    }

    @Override
    public int getBlockHeight(BlockPos pos) {
        if (!this.volume.isInside(pos.getX(), pos.getY(), pos.getZ())) {
            return this.level.getMaxBuildHeight() + 1;
        }
        int relBlockX = pos.getX() - this.originBlockX;
        int relBlockZ = pos.getZ() - this.originBlockZ;
        int[] lightArrays = this.HEIGHT_MAP[MixinLevelSlice.eclipticseasons$getLocalSectionIndex(relBlockX >> 4, relBlockZ >> 4)];
        int localBlockX = relBlockX & 0xF;
        int localBlockZ = relBlockZ & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getSolidBlockHeight(BlockPos pos) {
        if (!this.volume.isInside(pos.getX(), pos.getY(), pos.getZ())) {
            return this.level.getMaxBuildHeight() + 1;
        }
        int relBlockX = pos.getX() - this.originBlockX;
        int relBlockZ = pos.getZ() - this.originBlockZ;
        int[] lightArrays = this.SOLID_HEIGHT_MAP[MixinLevelSlice.eclipticseasons$getLocalSectionIndex(relBlockX >> 4, relBlockZ >> 4)];
        int localBlockX = relBlockX & 0xF;
        int localBlockZ = relBlockZ & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getSurfaceFaceBiomeId(BlockPos pos) {
        int relBlockX = pos.getX() - this.originBlockX;
        int relBlockZ = pos.getZ() - this.originBlockZ;
        int[] lightArrays = this.BIOME_MAP[MixinLevelSlice.eclipticseasons$getLocalSectionIndex(relBlockX >> 4, relBlockZ >> 4)];
        int localBlockX = relBlockX & 0xF;
        int localBlockZ = relBlockZ & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getSnowyStatus(BlockPos pos) {
        if (!this.volume.isInside(pos.getX(), pos.getY(), pos.getZ())) {
            return 0;
        }
        int relBlockX = pos.getX() - this.originBlockX;
        int relBlockZ = pos.getZ() - this.originBlockZ;
        int[] lightArrays = this.SNOWY_MAP[MixinLevelSlice.eclipticseasons$getLocalSectionIndex(relBlockX >> 4, relBlockZ >> 4)];
        int localBlockX = relBlockX & 0xF;
        int localBlockZ = relBlockZ & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public boolean isSnowyBlock(BlockPos pos) {
        int relBlockZ;
        if (!this.volume.isInside(pos.getX(), pos.getY(), pos.getZ())) {
            return false;
        }
        int relBlockX = pos.getX() - this.originBlockX;
        SnowyStatusKeeper lightArrays = this.SNOWY_STATUS_MAP[MixinLevelSlice.eclipticseasons$getLocalSectionIndex(relBlockX >> 4, (relBlockZ = pos.getZ() - this.originBlockZ) >> 4)];
        return lightArrays != null && lightArrays.isSnowyBlock(pos);
    }

    @Override
    public BlockPos.MutableBlockPos getModelCheckPos() {
        return this.eclipticseasons$checkPos;
    }

    @Inject(remap=false, method={"reset"}, at={@At(value="RETURN")})
    private void eclipticseasons$release(CallbackInfo ci) {
        this.eclipticseasons$rendererHolder.resetAll();
        Arrays.fill(this.SNOWY_STATUS_MAP, null);
    }

    @Override
    public ExtraRendererContext eclipticseasons$getContext() {
        return this.eclipticseasons$rendererHolder;
    }
}

