/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons;

import com.teamtea.eclipticseasons.common.block.IceOrSnowCauldronBlock;
import com.teamtea.eclipticseasons.common.registry.AttachmentRegistry;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import com.teamtea.eclipticseasons.common.registry.LootItemConditionRegistry;
import com.teamtea.eclipticseasons.common.registry.ModAdvancements;
import com.teamtea.eclipticseasons.common.registry.TestContents;
import com.teamtea.eclipticseasons.compat.CompatModule;
import com.teamtea.eclipticseasons.config.ClientConfig;
import com.teamtea.eclipticseasons.config.CommonConfig;
import com.teamtea.eclipticseasons.config.StartConfig;
import com.teamtea.eclipticseasons.data.start;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="eclipticseasons")
public class EclipticSeasons {
    public static final Logger LOGGER = LogManager.getLogger((String)"eclipticseasons");
    public static final String NETWORK_VERSION = "1.0";

    public EclipticSeasons(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(CommonConfig::UpdateConfig);
        modEventBus.addListener(ClientConfig::UpdateConfig);
        modEventBus.addListener(this::FMLCommonSetup);
        modEventBus.addListener(this::FMLCommonSetup);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(CompatModule::onInterModEnqueue);
        BlockRegistry.BLOCK_DEFERRED_REGISTER.register(modEventBus);
        ItemRegistry.ITEM_DEFERRED_REGISTER.register(modEventBus);
        BlockEntityRegistry.BLOCK_ENTITY_TYPE_DEFERRED_REGISTER.register(modEventBus);
        ModAdvancements.TRIGGER_DEFERRED_REGISTER.register(modEventBus);
        AttachmentRegistry.ATTACHMENT_TYPES.register(modEventBus);
        TestContents.weathers.register(modEventBus);
        LootItemConditionRegistry.LOOT_ITEM_CONDITION_TYPE_DEFERRED_REGISTER.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)StartConfig.START_CONFIG);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        CompatModule.register(NeoForge.EVENT_BUS, modEventBus);
    }

    public static ResourceLocation rl(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"eclipticseasons", (String)id);
    }

    public static ResourceLocation parse(String id) {
        return ResourceLocation.parse((String)id);
    }

    public void FMLCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(CompatModule::setup);
        event.enqueueWork(IceOrSnowCauldronBlock::init);
    }

    public void gatherData(GatherDataEvent event) {
        start.dataGen(event);
    }

    public static void logger(Exception exception) {
        LOGGER.error((Object)exception);
    }

    public static void logger(String x) {
        LOGGER.info(x);
    }

    public static void logger(Object ... x) {
        EclipticSeasons.extraLogger(false, x);
    }

    public static void extraLogger(boolean debug, Object ... x) {
        StringBuilder output = new StringBuilder();
        for (Object i : x) {
            if (i == null) {
                output.append(", ").append("null");
                continue;
            }
            if (i.getClass().isArray()) {
                output.append(", [");
                if (i instanceof Object[]) {
                    Object[] objects;
                    for (Object c : objects = (Object[])i) {
                        output.append(c).append(",");
                    }
                } else if (i instanceof float[]) {
                    float[] objects;
                    for (float c : objects = (float[])i) {
                        output.append(c).append(",");
                    }
                } else if (i instanceof int[]) {
                    int[] objects;
                    for (int c : objects = (int[])i) {
                        output.append(c).append(",");
                    }
                } else if (i instanceof double[]) {
                    double[] objects;
                    for (double c : objects = (double[])i) {
                        output.append(c).append(",");
                    }
                } else if (i instanceof long[]) {
                    long[] objects;
                    for (long c : objects = (long[])i) {
                        output.append(c).append(",");
                    }
                } else if (i instanceof boolean[]) {
                    boolean[] objects;
                    for (boolean c : objects = (boolean[])i) {
                        output.append(c).append(",");
                    }
                }
                output.append("]");
                continue;
            }
            if (i instanceof List) {
                List list = (List)i;
                output.append(", [");
                for (Object c : list) {
                    output.append(c);
                }
                output.append("]");
                continue;
            }
            output.append(", ").append(i);
        }
        if (debug) {
            LOGGER.debug(output.substring(1));
        } else {
            LOGGER.info(output.substring(1));
        }
    }
}

