/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.climate.seasonal;

import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import java.util.Locale;

public enum HotRain implements BiomeRain
{
    BEGINNING_OF_SPRING(0.2f),
    RAIN_WATER(0.35f, 0.04f),
    INSECTS_AWAKENING(0.35f, 0.05f),
    SPRING_EQUINOX(0.2f, 0.01f),
    FRESH_GREEN(0.35f, 0.005f),
    GRAIN_RAIN(0.45f),
    BEGINNING_OF_SUMMER(0.5f),
    LESSER_FULLNESS(0.45f, 0.1f),
    GRAIN_IN_EAR(0.95f, 0.5f),
    SUMMER_SOLSTICE(0.9f, 0.28f),
    LESSER_HEAT(0.85f, 0.3f),
    GREATER_HEAT(0.75f, 0.25f),
    BEGINNING_OF_AUTUMN(0.72f, 0.2f),
    END_OF_HEAT(0.7f, 0.1f),
    WHITE_DEW(0.65f, 0.08f),
    AUTUMNAL_EQUINOX(0.62f, 0.05f),
    COLD_DEW(0.5f, 0.02f),
    FIRST_FROST(0.45f, 0.005f),
    BEGINNING_OF_WINTER(0.3f),
    LIGHT_SNOW(0.2f),
    HEAVY_SNOW(0.3f),
    WINTER_SOLSTICE(0.25f),
    LESSER_COLD(0.2f),
    GREATER_COLD(0.15f),
    NONE(0.0f, 0.0f);

    private final float rainChane;
    private final float thunderChance;
    private static final HotRain[] values;

    private HotRain(float rainChane) {
        this(rainChane, 0.0f);
    }

    private HotRain(float rainChane, float thunderChance) {
        this.rainChane = rainChane;
        this.thunderChance = thunderChance;
    }

    public String getName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public float getRainChance() {
        return this.rainChane;
    }

    @Override
    public float getThunderChance() {
        return this.thunderChance;
    }

    @Override
    public SolarTerm getSolarTerm() {
        return SolarTerm.collectValues()[this.ordinal()];
    }

    @Override
    public Season getSeason() {
        return Season.collectValues()[this.ordinal() / 6];
    }

    public static HotRain[] collectValues() {
        return values;
    }

    static {
        values = HotRain.values();
    }
}

