/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.crop;

import com.teamtea.eclipticseasons.api.constant.solar.Season;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CropSeasonInfo {
    private final int season;

    public CropSeasonInfo(int season) {
        this.season = season;
    }

    public boolean isSuitable(Season season) {
        if (season == Season.NONE) {
            return true;
        }
        return (this.season >> season.ordinal() & 1) == 1;
    }

    public float getGrowChance(Season sea) {
        boolean spring = (this.season & 1) == 1;
        boolean summer = (this.season & 2) == 2;
        boolean autumn = (this.season & 4) == 4;
        boolean winter = (this.season & 8) == 8;
        switch (sea) {
            case SPRING: {
                if (!spring) break;
                return 1.2f;
            }
            case SUMMER: {
                if (!summer) break;
                return 1.4f;
            }
            case AUTUMN: {
                if (!autumn) break;
                return 1.0f;
            }
            case WINTER: {
                if (!winter) break;
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public List<Component> getTooltip() {
        boolean winter;
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)"info.eclipticseasons.environment.season").withStyle(ChatFormatting.GRAY));
        boolean spring = (this.season & 1) == 1;
        boolean summer = (this.season & 2) == 2;
        boolean autumn = (this.season & 4) == 4;
        boolean bl = winter = (this.season & 8) == 8;
        if (spring && summer && autumn && winter) {
            list.add((Component)Season.NONE.getTranslation());
        } else {
            MutableComponent mutableComponent = Component.empty();
            int hashCode = mutableComponent.hashCode();
            if (spring) {
                list.add((Component)Season.SPRING.getTranslation());
            }
            if (summer) {
                list.add((Component)Season.SUMMER.getTranslation());
            }
            if (autumn) {
                list.add((Component)Season.AUTUMN.getTranslation());
            }
            if (winter) {
                list.add((Component)Season.WINTER.getTranslation());
            }
            if (mutableComponent.hashCode() != hashCode) {
                list.add((Component)mutableComponent);
            }
        }
        return list;
    }

    public static int getSeason(List<Season> seasons) {
        int season = 0;
        for (Season season1 : seasons) {
            season += (switch (season1) {
                case Season.SPRING -> 1;
                case Season.SUMMER -> 2;
                case Season.AUTUMN -> 4;
                case Season.WINTER -> 8;
                default -> 0;
            });
        }
        return season;
    }

    public static List<Component> getTooltip(int season) {
        boolean winter;
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)"info.eclipticseasons.environment.season").withStyle(ChatFormatting.GRAY));
        boolean spring = (season & 1) == 1;
        boolean summer = (season & 2) == 2;
        boolean autumn = (season & 4) == 4;
        boolean bl = winter = (season & 8) == 8;
        if (spring && summer && autumn && winter) {
            list.add((Component)Season.NONE.getTranslation());
        } else {
            MutableComponent mutableComponent = Component.empty();
            int hashCode = mutableComponent.hashCode();
            if (spring) {
                list.add((Component)Season.SPRING.getTranslation());
            }
            if (summer) {
                list.add((Component)Season.SUMMER.getTranslation());
            }
            if (autumn) {
                list.add((Component)Season.AUTUMN.getTranslation());
            }
            if (winter) {
                list.add((Component)Season.WINTER.getTranslation());
            }
            if (mutableComponent.hashCode() != hashCode) {
                list.add((Component)mutableComponent);
            }
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CropSeasonInfo that = (CropSeasonInfo)o;
        return this.season == that.season;
    }

    public int hashCode() {
        return Objects.hashCode(this.season);
    }
}

