/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.solar;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.misc.ITranslatableWithPlaceholder;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum Season implements ITranslatableWithPlaceholder
{
    SPRING(ChatFormatting.DARK_GREEN),
    SUMMER(ChatFormatting.RED),
    AUTUMN(ChatFormatting.GOLD),
    WINTER(ChatFormatting.BLUE),
    NONE(ChatFormatting.DARK_AQUA);

    private final ChatFormatting color;
    private static final Season[] seasons;
    private static final Season[] validSeasons;

    private Season(ChatFormatting color) {
        this.color = color;
    }

    @Override
    public String getName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    public MutableComponent getTranslation() {
        return Component.translatable((String)("info.eclipticseasons.environment.season." + this.getName())).withStyle(this.color);
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public String toString() {
        return super.toString();
    }

    public static Season[] collectValues() {
        return seasons;
    }

    public static Season[] collectValidValues() {
        return validSeasons;
    }

    @Override
    public boolean isValid() {
        return this != NONE;
    }

    public boolean isInTerms(Season start2, Season end) {
        if (start2 == NONE || end == NONE) {
            return false;
        }
        if (start2 == end) {
            return this == start2;
        }
        if (start2.ordinal() <= end.ordinal()) {
            return start2.ordinal() <= this.ordinal() && this.ordinal() <= end.ordinal();
        }
        return start2.ordinal() <= this.ordinal() || this.ordinal() <= end.ordinal();
    }

    public SolarTerm getFirstSolarTerm() {
        return SolarTerm.get(this.ordinal() * 6);
    }

    public SolarTerm getEndSolarTerm() {
        return SolarTerm.get(this.ordinal() * 6 + 5);
    }

    public SolarTerm getFirstSolarTerm(AgroClimaticZone climate) {
        if (climate == null) {
            return this.getFirstSolarTerm();
        }
        if (climate.seasonalSignalDurations().isEmpty()) {
            return SolarTerm.NONE;
        }
        int ordinal = 0;
        int foundCount = 0;
        for (Pair<Season, Integer> pair : climate.seasonalSignalDurations()) {
            if (pair.getFirst() == this) {
                if (foundCount > 0 || ordinal > 0) {
                    return SolarTerm.get(ordinal);
                }
                ++foundCount;
            }
            ordinal += ((Integer)pair.getSecond()).intValue();
        }
        return SolarTerm.get(foundCount == 1 ? 0 : ordinal - 1);
    }

    public SolarTerm getEndSolarTerm(AgroClimaticZone climate) {
        if (climate == null) {
            return this.getEndSolarTerm();
        }
        if (climate.seasonalSignalDurations().isEmpty()) {
            return SolarTerm.NONE;
        }
        int ordinal = 0;
        for (Pair<Season, Integer> pair : climate.seasonalSignalDurations()) {
            ordinal += ((Integer)pair.getSecond()).intValue();
            if (pair.getFirst() != this) continue;
            return SolarTerm.collectValues()[ordinal - 1];
        }
        return SolarTerm.NONE;
    }

    static {
        seasons = Season.values();
        validSeasons = (Season[])Arrays.stream(Season.values()).filter(Season::isValid).toArray(Season[]::new);
    }
}

