/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.solar;

import com.teamtea.eclipticseasons.api.misc.ITranslatable;
import net.minecraft.network.chat.Component;

public enum TimePeriod implements ITranslatable
{
    DAWN,
    DAY,
    DUSK,
    NIGHT,
    MIDNIGHT,
    NONE;

    private static final TimePeriod[] timePeriods;

    public static TimePeriod[] collectValues() {
        return timePeriods;
    }

    public static TimePeriod fromTimeOfDay(float timeOfDay) {
        float angle = (timeOfDay * 20.0f + 5.0f) % 20.0f;
        if ((double)angle > 0.83 && angle < 10.0f) {
            return DAY;
        }
        if (angle < 11.42f) {
            return DUSK;
        }
        if (angle < 15.0f) {
            return NIGHT;
        }
        if (angle < 19.16f) {
            return MIDNIGHT;
        }
        return DAWN;
    }

    @Override
    public Component getTranslation() {
        return Component.translatable((String)("info.eclipticseasons.environment.time_period." + this.getName()));
    }

    static {
        timePeriods = TimePeriod.values();
    }
}

