/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.solar.color.base;

import com.teamtea.eclipticseasons.api.constant.solar.color.base.SolarTermColor;
import com.teamtea.eclipticseasons.client.util.ColorHelper;
import net.minecraft.world.level.FoliageColor;

public enum TemperateSolarTermColors implements SolarTermColor
{
    BEGINNING_OF_SPRING(12689779, 0.32f, 12689779, 0.32f),
    RAIN_WATER(12689779, 0.16f, 12689779, 0.16f),
    INSECTS_AWAKENING(0, 0.0f),
    SPRING_EQUINOX(0, 0.0f),
    FRESH_GREEN(8370190, 0.16f),
    GRAIN_RAIN(8370190, 0.32f),
    BEGINNING_OF_SUMMER(8370190, 0.48f),
    LESSER_FULLNESS(8370190, 0.64f, 8370190, 0.1f),
    GRAIN_IN_EAR(8370190, 0.8f, 8370190, 0.2f),
    SUMMER_SOLSTICE(8370190, 0.8f, 8370190, 0.3f),
    LESSER_HEAT(ColorHelper.simplyMixColor(8370190, 0.8f, 13734463, 0.2f), 0.8f, 8370190, 0.4f),
    GREATER_HEAT(ColorHelper.simplyMixColor(8370190, 0.6f, 13734463, 0.4f), 0.8f, 16765952, 0.25f),
    BEGINNING_OF_AUTUMN(ColorHelper.simplyMixColor(8370190, 0.4f, 13734463, 0.6f), 0.8f, 16765952, 0.5f),
    END_OF_HEAT(ColorHelper.simplyMixColor(8370190, 0.2f, 13734463, 0.8f), 0.8f, 16765952, 0.75f),
    WHITE_DEW(13734463, 0.8f, 16765952, 1.0f),
    AUTUMNAL_EQUINOX(13734463, 0.8f, 16765952, 1.0f),
    COLD_DEW(ColorHelper.simplyMixColor(13734463, 0.8f, 12689779, 0.2f), 0.8f, 16765952, 1.0f),
    FIRST_FROST(ColorHelper.simplyMixColor(13734463, 0.6f, 12689779, 0.4f), 0.8f, ColorHelper.simplyMixColor(16765952, 0.8f, 12689779, 0.2f), 1.0f),
    BEGINNING_OF_WINTER(ColorHelper.simplyMixColor(13734463, 0.4f, 12689779, 0.6f), 0.8f, ColorHelper.simplyMixColor(16765952, 0.6f, 12689779, 0.4f), 1.0f),
    LIGHT_SNOW(ColorHelper.simplyMixColor(13734463, 0.2f, 12689779, 0.8f), 0.8f, ColorHelper.simplyMixColor(16765952, 0.4f, 12689779, 0.6f), 1.0f),
    HEAVY_SNOW(12689779, 0.8f, ColorHelper.simplyMixColor(16765952, 0.2f, 12689779, 0.8f), 1.0f),
    WINTER_SOLSTICE(12689779, 0.8f, 12689779, 0.8f),
    LESSER_COLD(12689779, 0.64f, 12689779, 0.64f),
    GREATER_COLD(12689779, 0.48f, 12689779, 0.48f),
    NONE(-1, 0.0f, -1, 0.0f);

    private final int temperateColor;
    private final float temperateMix;
    private final int birchColor;
    private static final TemperateSolarTermColors[] values;

    private TemperateSolarTermColors(int temperateColorIn, float temperateMixIn, int birchColorIn, float birchAlphaIn) {
        this.temperateColor = temperateColorIn;
        this.temperateMix = temperateMixIn;
        this.birchColor = ColorHelper.simplyMixColor(birchColorIn, birchAlphaIn, FoliageColor.getDefaultColor(), 1.0f - birchAlphaIn);
    }

    private TemperateSolarTermColors(int temperateColorIn, float temperateMix) {
        this.temperateColor = temperateColorIn;
        this.temperateMix = temperateMix;
        this.birchColor = FoliageColor.getDefaultColor();
    }

    public static TemperateSolarTermColors get(int index) {
        return TemperateSolarTermColors.collectValues()[index];
    }

    @Override
    public int getGrassColor() {
        return this.temperateColor;
    }

    @Override
    public float getMix() {
        return this.temperateMix;
    }

    @Override
    public int getLeaveColor() {
        return this.birchColor;
    }

    public static TemperateSolarTermColors[] collectValues() {
        return values;
    }

    static {
        values = TemperateSolarTermColors.values();
    }
}

