/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.solar.color.base.seasonal;

import com.teamtea.eclipticseasons.api.constant.solar.color.base.SolarTermColor;
import com.teamtea.eclipticseasons.client.util.ColorHelper;
import net.minecraft.world.level.FoliageColor;

public enum HotSolarTermColors implements SolarTermColor
{
    BEGINNING_OF_SPRING(12689779, 0.1f, 12689779, 0.1f),
    RAIN_WATER(0, 0.0f),
    INSECTS_AWAKENING(8370190, 0.08f),
    SPRING_EQUINOX(8370190, 0.16f),
    FRESH_GREEN(8370190, 0.2f),
    GRAIN_RAIN(8370190, 0.25f),
    BEGINNING_OF_SUMMER(8370190, 0.3f, 8370190, 0.05f),
    LESSER_FULLNESS(8370190, 0.35f, 8370190, 0.1f),
    GRAIN_IN_EAR(8370190, 0.4f, 8370190, 0.15f),
    SUMMER_SOLSTICE(8370190, 0.4f, 8370190, 0.2f),
    LESSER_HEAT(ColorHelper.simplyMixColor(8370190, 0.8f, 13734463, 0.2f), 0.4f, 8370190, 0.2f),
    GREATER_HEAT(ColorHelper.simplyMixColor(8370190, 0.8f, 13734463, 0.2f), 0.45f, 16765952, 0.25f),
    BEGINNING_OF_AUTUMN(ColorHelper.simplyMixColor(8370190, 0.7f, 13734463, 0.3f), 0.4f, 16765952, 0.2f),
    END_OF_HEAT(ColorHelper.simplyMixColor(8370190, 0.6f, 13734463, 0.4f), 0.4f, 16765952, 0.2f),
    WHITE_DEW(ColorHelper.simplyMixColor(8370190, 0.58f, 13734463, 0.42f), 0.4f, 16765952, 0.2f),
    AUTUMNAL_EQUINOX(ColorHelper.simplyMixColor(8370190, 0.55f, 13734463, 0.45f), 0.4f, 16765952, 0.15f),
    COLD_DEW(ColorHelper.simplyMixColor(8370190, 0.52f, 13734463, 0.48f), 0.4f, 16765952, 0.12f),
    FIRST_FROST(ColorHelper.simplyMixColor(13734463, 0.5f, 12689779, 0.5f), 0.35f, ColorHelper.simplyMixColor(16765952, 0.8f, 12689779, 0.2f), 0.2f),
    BEGINNING_OF_WINTER(ColorHelper.simplyMixColor(13734463, 0.5f, 12689779, 0.5f), 0.35f, ColorHelper.simplyMixColor(16765952, 0.6f, 12689779, 0.4f), 0.25f),
    LIGHT_SNOW(ColorHelper.simplyMixColor(13734463, 0.4f, 12689779, 0.6f), 0.35f, ColorHelper.simplyMixColor(16765952, 0.5f, 12689779, 0.5f), 0.35f),
    HEAVY_SNOW(ColorHelper.simplyMixColor(13734463, 0.3f, 12689779, 0.7f), 0.35f, ColorHelper.simplyMixColor(16765952, 0.2f, 12689779, 0.8f), 0.35f),
    WINTER_SOLSTICE(12689779, 0.35f, 12689779, 0.35f),
    LESSER_COLD(12689779, 0.35f, 12689779, 0.3f),
    GREATER_COLD(12689779, 0.2f, 12689779, 0.2f),
    NONE(-1, 0.0f, -1, 0.0f);

    private final int temperateColor;
    private final float temperateMix;
    private final int birchColor;
    private static final HotSolarTermColors[] values;

    private HotSolarTermColors(int temperateColorIn, float temperateMixIn, int birchColorIn, float birchAlphaIn) {
        this.temperateColor = temperateColorIn;
        this.temperateMix = temperateMixIn;
        this.birchColor = ColorHelper.simplyMixColor(birchColorIn, birchAlphaIn, FoliageColor.getDefaultColor(), 1.0f - birchAlphaIn);
    }

    private HotSolarTermColors(int temperateColorIn, float temperateMix) {
        this.temperateColor = temperateColorIn;
        this.temperateMix = temperateMix;
        this.birchColor = FoliageColor.getDefaultColor();
    }

    public static HotSolarTermColors get(int index) {
        return HotSolarTermColors.collectValues()[index];
    }

    @Override
    public int getGrassColor() {
        return this.temperateColor;
    }

    @Override
    public float getMix() {
        return this.temperateMix;
    }

    @Override
    public int getLeaveColor() {
        return this.birchColor;
    }

    public static HotSolarTermColors[] collectValues() {
        return values;
    }

    static {
        values = HotSolarTermColors.values();
    }
}

