/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.client.model.variant;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Generated;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.resources.ResourceLocation;

public class VariantLike
extends Variant {
    public static final Codec<VariantLike> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(Variant::getModelLocation), (App)Codec.INT.optionalFieldOf("x", (Object)0).forGetter(VariantLike::getX), (App)Codec.INT.optionalFieldOf("y", (Object)0).forGetter(VariantLike::getY), (App)Codec.BOOL.optionalFieldOf("uvlock", (Object)false).forGetter(Variant::isUvLocked), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(Variant::getWeight)).apply((Applicative)ins, VariantLike::new));
    private final int x;
    private final int y;

    public VariantLike(ResourceLocation modelLocation, int x, int y, boolean uvLock, int weight) {
        super(modelLocation, BlockModelRotation.by((int)x, (int)y).getRotation(), uvLock, weight);
        this.x = x;
        this.y = y;
    }

    public static VariantBuilder builder(ResourceLocation modelLocation) {
        return new VariantBuilder(modelLocation);
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    public static class VariantBuilder {
        private ResourceLocation modelLocation;
        private int rotationX = 0;
        private int rotationY = 0;
        private boolean uvLocked = false;
        private int weight = 1;

        public VariantBuilder(ResourceLocation modelLocation) {
            this.modelLocation = modelLocation;
        }

        public VariantBuilder model(ResourceLocation modelLocation) {
            this.modelLocation = modelLocation;
            return this;
        }

        public VariantBuilder rotationX(int rotationX) {
            this.rotationX = rotationX;
            return this;
        }

        public VariantBuilder rotationY(int rotationY) {
            this.rotationY = rotationY;
            return this;
        }

        public VariantBuilder uvLocked(boolean uvLocked) {
            this.uvLocked = uvLocked;
            return this;
        }

        public VariantBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public VariantLike build() {
            if (this.modelLocation == null) {
                throw new IllegalStateException("Model location must be set");
            }
            Preconditions.checkArgument((BlockModelRotation.by((int)this.rotationX, (int)this.rotationY) != null ? 1 : 0) != 0, (String)"Invalid model rotation x=%d, y=%d", (int)this.rotationX, (int)this.rotationY);
            return new VariantLike(this.modelLocation, this.rotationX, this.rotationY, this.uvLocked, this.weight);
        }
    }
}

