/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.crop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.crop.CropGrowControl;
import com.teamtea.eclipticseasons.api.data.crop.GrowParameter;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.common.misc.SimplePair;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.block.Block;

public record CropGrowControlBuilder(HolderSet<AgroClimaticZone> cropClimateType, BlockPredicate applyTarget, HolderSet<CropGrowControlBuilder> parent, Optional<GrowParameter> defaultSolarTermGrowParameter, Optional<GrowParameter> defaultHumidityGrowParameter, Enum2ObjectMap<SolarTerm, GrowParameter> solarTermList, Enum2ObjectMap<Season, GrowParameter> seasonList, Enum2ObjectMap<Humidity, GrowParameter> humidList, Optional<BlockPredicate> notGreenHouse) {
    public static final Codec<SolarTerm> SOLAR_TERM_CODEC_STRING = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)SolarTerm.valueOf(s.toUpperCase()));
        }
        catch (ResourceLocationException resourcelocationexception) {
            return DataResult.error(() -> "Not a valid solar term: " + s + " " + resourcelocationexception.getMessage());
        }
    }, SolarTerm::getName).stable();
    public static final Codec<Enum2ObjectMap<Season, GrowParameter>> Season_ENUM_MAP_CODEC = CodecUtil.enum2ObjectMapCodec(ESExtraCodec.SEASON, GrowParameter.CODEC, Season.class);
    public static final Codec<Enum2ObjectMap<Humidity, GrowParameter>> HUMID_ENUM_MAP_CODEC = CodecUtil.enum2ObjectMapCodec(ESExtraCodec.HUMIDITY, GrowParameter.CODEC, Humidity.class);
    public static final Codec<Enum2ObjectMap<SolarTerm, GrowParameter>> SOLAR_TERM_ENUM_MAP_CODEC = CodecUtil.enum2ObjectMapCodec(ESExtraCodec.SOLAR_TERM, GrowParameter.CODEC, SolarTerm.class);
    public static final Codec<CropGrowControlBuilder> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)GrowParameter.CODEC.optionalFieldOf("humidity_default").forGetter(CropGrowControlBuilder::defaultHumidityGrowParameter), (App)SOLAR_TERM_ENUM_MAP_CODEC.optionalFieldOf("solar_terms", new Enum2ObjectMap(SolarTerm.class)).forGetter(CropGrowControlBuilder::solarTermList), (App)Season_ENUM_MAP_CODEC.optionalFieldOf("seasons", new Enum2ObjectMap(Season.class)).forGetter(CropGrowControlBuilder::seasonList), (App)HUMID_ENUM_MAP_CODEC.optionalFieldOf("humidity", new Enum2ObjectMap(Humidity.class)).forGetter(CropGrowControlBuilder::humidList), (App)CodecUtil.holderSetCodec(ESRegistries.AGRO_CLIMATE).fieldOf("climate").forGetter(CropGrowControlBuilder::cropClimateType), (App)BlockPredicate.CODEC.optionalFieldOf("unlike_greenhouse_material").forGetter(CropGrowControlBuilder::notGreenHouse), (App)CodecUtil.holderSetCodec(ESRegistries.CROP).fieldOf("parent").orElse((Object)HolderSet.empty()).forGetter(CropGrowControlBuilder::parent), (App)GrowParameter.CODEC.optionalFieldOf("season_default").forGetter(CropGrowControlBuilder::defaultSolarTermGrowParameter), (App)BlockPredicate.CODEC.fieldOf("apply_target").forGetter(CropGrowControlBuilder::applyTarget)).apply((Applicative)ins, (defaultGrowParameter2, solarTermGrowParameterEnumMap, seasonGrowParameterEnumMap, humidityGrowParameterEnumMap, holders, notGreenHouse, holders2, defaultGrowParameter, blockPredicate) -> new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)holders, (BlockPredicate)blockPredicate, (HolderSet<CropGrowControlBuilder>)holders2, (Optional<GrowParameter>)defaultGrowParameter, (Optional<GrowParameter>)defaultGrowParameter2, (Enum2ObjectMap<SolarTerm, GrowParameter>)solarTermGrowParameterEnumMap, (Enum2ObjectMap<Season, GrowParameter>)seasonGrowParameterEnumMap, (Enum2ObjectMap<Humidity, GrowParameter>)humidityGrowParameterEnumMap, (Optional<BlockPredicate>)notGreenHouse)));

    public SimplePair<Block, CropGrowControl> build() {
        SimplePair<Object, Object> pair = SimplePair.of(null, null);
        return pair;
    }

    public boolean isChildClimateType(HolderSet<AgroClimaticZone> parentClimateType) {
        Holder cropClimateTypeHolder;
        int i;
        if (this.cropClimateType().size() > parentClimateType.size()) {
            return false;
        }
        HashSet<Holder> cropClimateTypes = new HashSet<Holder>();
        for (i = 0; i < parentClimateType.size(); ++i) {
            cropClimateTypeHolder = parentClimateType.get(i);
            cropClimateTypes.add(cropClimateTypeHolder);
        }
        for (i = 0; i < this.cropClimateType().size(); ++i) {
            cropClimateTypeHolder = this.cropClimateType().get(i);
            if (cropClimateTypes.contains(cropClimateTypeHolder)) continue;
            return false;
        }
        return true;
    }
}

