/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;

public record SolarTermValueMap<T>(Optional<T> defaultValue, Optional<Enum2ObjectMap<SolarTerm, T>> solarTermMap, Optional<Holder<AgroClimaticZone>> climate, Optional<Enum2ObjectMap<Season, T>> seasonMap) {
    public static final Codec<SolarTermValueMap<Float>> FLOAT_CODEC = SolarTermValueMap.codec(Codec.FLOAT);
    public static final Codec<SolarTermValueMap<Integer>> INT_CODEC = SolarTermValueMap.codec(Codec.INT);
    public static final Enum2ObjectMap<Season, List<SolarTerm>> SEASON_TO_SOLAR_TERMS_MAP = SolarTermValueMap.convertToEnum2ObjectMapBase(Season.class, new EnumMap<Season, List<SolarTerm>>(Arrays.stream(SolarTerm.collectValues()).collect(Collectors.groupingBy(SolarTerm::getSeason))), c -> c);

    public static <B> Codec<SolarTermValueMap<B>> codec(Codec<B> codec) {
        return RecordCodecBuilder.create(ins -> ins.group((App)codec.optionalFieldOf("default").forGetter(SolarTermValueMap::defaultValue), (App)CodecUtil.enum2ObjectMapCodec(ESExtraCodec.SOLAR_TERM, codec, SolarTerm.class).optionalFieldOf("solar_terms").forGetter(SolarTermValueMap::solarTermMap), (App)CodecUtil.holderCodec(ESRegistries.AGRO_CLIMATE).optionalFieldOf("climate").forGetter(SolarTermValueMap::climate), (App)CodecUtil.enum2ObjectMapCodec(ESExtraCodec.SEASON, codec, Season.class).optionalFieldOf("seasons").forGetter(SolarTermValueMap::seasonMap)).apply((Applicative)ins, SolarTermValueMap::new));
    }

    public Enum2ObjectMap<SolarTerm, T> combine() {
        Enum2ObjectMap map = new Enum2ObjectMap(SolarTerm.class);
        if (this.solarTermMap().isPresent()) {
            map.putAll((Map)this.solarTermMap().get());
        }
        if (this.seasonMap().isPresent()) {
            Enum2ObjectMap<Season, List<SolarTerm>> usemap;
            if (this.climate.isPresent()) {
                usemap = new Enum2ObjectMap(Season.class);
                usemap.put(Season.NONE, List.of(SolarTerm.NONE));
                int i = 0;
                for (Pair<Season, Integer> pair : ((AgroClimaticZone)this.climate.get().value()).seasonalSignalDurations()) {
                    List solarTerms = usemap.computeIfAbsent((Season)pair.getFirst(), c -> new ArrayList());
                    solarTerms.addAll(Arrays.asList(SolarTerm.collectValues()).subList(i, (Integer)pair.getSecond() + i));
                    i += ((Integer)pair.getSecond()).intValue();
                }
            } else {
                usemap = SEASON_TO_SOLAR_TERMS_MAP;
            }
            this.seasonMap().get().forEach((season, t) -> {
                List associatedSolarTerms = (List)usemap.get((Season)season);
                if (associatedSolarTerms != null) {
                    for (SolarTerm solarTerm : associatedSolarTerms) {
                        map.putIfAbsent(solarTerm, t);
                    }
                }
            });
        }
        if (this.defaultValue().isPresent()) {
            for (SolarTerm solarTerm : SolarTerm.collectValues()) {
                map.putIfAbsent(solarTerm, this.defaultValue().get());
            }
        }
        return map;
    }

    public static <K extends Enum<K>, T, V> Enum2ObjectMap<K, V> convertToEnum2ObjectMapBase(Class<K> keyType, EnumMap<K, T> source, Function<T, V> converter) {
        Enum2ObjectMap<Enum, V> target = new Enum2ObjectMap<Enum, V>(keyType);
        for (Map.Entry<K, T> entry : source.entrySet()) {
            V apply = converter.apply(entry.getValue());
            if (apply == null) continue;
            target.put((Enum)entry.getKey(), apply);
        }
        return target;
    }

    public static <K extends Enum<K>, T, V> Enum2ObjectMap<K, V> convertToEnum2ObjectMap(Class<K> keyType, Enum2ObjectMap<K, T> source, Function<T, V> converter) {
        Enum2ObjectMap<Enum, V> target = new Enum2ObjectMap<Enum, V>(keyType);
        for (Map.Entry<K, T> entry : source.entrySet()) {
            V apply = converter.apply(entry.getValue());
            if (apply == null) continue;
            target.put((Enum)entry.getKey(), apply);
        }
        return target;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T> {
        private T defaultValue;
        private Enum2ObjectMap<SolarTerm, T> solarTermMap;
        private Enum2ObjectMap<Season, T> seasonMap;
        private Holder<AgroClimaticZone> climate;

        private Builder() {
        }

        public Builder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<T> solarTermMap(Enum2ObjectMap<SolarTerm, T> solarTermMap) {
            this.solarTermMap = solarTermMap;
            return this;
        }

        public Builder<T> seasonMap(Enum2ObjectMap<Season, T> seasonMap) {
            this.seasonMap = seasonMap;
            return this;
        }

        public Builder<T> putSolarTerm(SolarTerm term, T value) {
            if (this.solarTermMap == null) {
                this.solarTermMap = new Enum2ObjectMap(SolarTerm.class);
            }
            this.solarTermMap.put(term, value);
            return this;
        }

        public Builder<T> putSeason(Season season, T value) {
            if (this.seasonMap == null) {
                this.seasonMap = new Enum2ObjectMap(Season.class);
            }
            this.seasonMap.put(season, value);
            return this;
        }

        public void climate(Holder<AgroClimaticZone> climate) {
            this.climate = climate;
        }

        public SolarTermValueMap<T> build() {
            return new SolarTermValueMap<T>(Optional.ofNullable(this.defaultValue), Optional.ofNullable(this.solarTermMap), Optional.ofNullable(this.climate), Optional.ofNullable(this.seasonMap));
        }

        public Optional<SolarTermValueMap<T>> ofBuild() {
            return Optional.of(new SolarTermValueMap<T>(Optional.ofNullable(this.defaultValue), Optional.ofNullable(this.solarTermMap), Optional.ofNullable(this.climate), Optional.ofNullable(this.seasonMap)));
        }
    }
}

