/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.season.definition.selector;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.data.season.definition.ISeasonChangeContext;
import com.teamtea.eclipticseasons.api.data.season.definition.condition.IChangeCondition;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.ChangeSelectors;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.IChangeSelector;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.common.core.crop.NaturalPlantHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootTable;

public class BlockSelector
implements IChangeSelector {
    public static final MapCodec<BlockSelector> CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)BlockState.CODEC.optionalFieldOf("block").forGetter(o -> o.state), (App)Codec.BOOL.optionalFieldOf("replace").forGetter(o -> o.replace), (App)Codec.BOOL.optionalFieldOf("copy_state", (Object)false).forGetter(o -> o.copyState), (App)Codec.STRING.listOf().optionalFieldOf("copy_properties").forGetter(o -> o.copyStateProperties), (App)Codec.INT.optionalFieldOf("weight", (Object)10).forGetter(o -> o.weight), (App)CodecUtil.listFrom(IChangeCondition.CODEC).optionalFieldOf("conditions", List.of()).forGetter(o -> o.conditions), (App)Vec3i.CODEC.optionalFieldOf("offset").forGetter(o -> o.offset), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).optionalFieldOf("loot").forGetter(o -> o.loot)).apply((Applicative)ins, BlockSelector::new));
    private final Optional<BlockState> state;
    private final Optional<Boolean> replace;
    private final boolean copyState;
    private final Optional<List<String>> copyStateProperties;
    private final int weight;
    private final List<IChangeCondition> conditions;
    private final Optional<Vec3i> offset;
    private final Optional<ResourceKey<LootTable>> loot;

    @Override
    public ResourceLocation getType() {
        return ChangeSelectors.BLOCK;
    }

    @Override
    public MapCodec<? extends IChangeSelector> codec() {
        return CODEC;
    }

    @Override
    public boolean place(ServerLevel level, BlockPos newpos, ISeasonChangeContext context) {
        boolean applied = false;
        if (this.state.isEmpty()) {
            applied = level.removeBlock(newpos, false);
        } else {
            BlockState newState = this.state.get();
            BlockPos blockPos = newpos = this.offset.isEmpty() ? newpos : newpos.offset(this.offset.get());
            if (this.offset.isEmpty()) {
                BlockState oldState = level.getBlockState(newpos);
                if (this.copyState) {
                    Set propertyNameList = this.copyStateProperties.map(HashSet::new).orElse(null);
                    for (Property property : oldState.getProperties()) {
                        if (!newState.hasProperty(property) || propertyNameList != null && !propertyNameList.contains(property.getName())) continue;
                        newState = (BlockState)newState.setValue(property, oldState.getValue(property));
                    }
                }
                applied = NaturalPlantHandler.setBlockAndSelfCheck(level, newpos, newState, oldState);
            } else if (this.replace.isEmpty()) {
                BlockState oldState = level.getBlockState(newpos);
                if (oldState.canBeReplaced(Fluids.EMPTY)) {
                    applied = NaturalPlantHandler.setBlockAndSelfCheck(level, newpos, newState);
                }
            } else if (this.replace.get().booleanValue() || level.isEmptyBlock(newpos)) {
                applied = NaturalPlantHandler.setBlockAndSelfCheck(level, newpos, newState);
            }
        }
        return applied;
    }

    @Generated
    private static Optional<BlockState> $default$state() {
        return Optional.empty();
    }

    @Generated
    private static Optional<Boolean> $default$replace() {
        return Optional.empty();
    }

    @Generated
    private static boolean $default$copyState() {
        return false;
    }

    @Generated
    private static Optional<List<String>> $default$copyStateProperties() {
        return Optional.empty();
    }

    @Generated
    private static int $default$weight() {
        return 10;
    }

    @Generated
    private static Optional<Vec3i> $default$offset() {
        return Optional.empty();
    }

    @Generated
    private static Optional<ResourceKey<LootTable>> $default$loot() {
        return Optional.empty();
    }

    @Generated
    BlockSelector(Optional<BlockState> state, Optional<Boolean> replace, boolean copyState, Optional<List<String>> copyStateProperties, int weight, List<IChangeCondition> conditions, Optional<Vec3i> offset, Optional<ResourceKey<LootTable>> loot) {
        this.state = state;
        this.replace = replace;
        this.copyState = copyState;
        this.copyStateProperties = copyStateProperties;
        this.weight = weight;
        this.conditions = conditions;
        this.offset = offset;
        this.loot = loot;
    }

    @Generated
    public static BlockSelectorBuilder builder() {
        return new BlockSelectorBuilder();
    }

    @Generated
    public Optional<BlockState> getState() {
        return this.state;
    }

    @Generated
    public Optional<Boolean> getReplace() {
        return this.replace;
    }

    @Generated
    public boolean isCopyState() {
        return this.copyState;
    }

    @Generated
    public Optional<List<String>> getCopyStateProperties() {
        return this.copyStateProperties;
    }

    @Override
    @Generated
    public int getWeight() {
        return this.weight;
    }

    @Override
    @Generated
    public List<IChangeCondition> getConditions() {
        return this.conditions;
    }

    @Generated
    public Optional<Vec3i> getOffset() {
        return this.offset;
    }

    @Override
    @Generated
    public Optional<ResourceKey<LootTable>> getLoot() {
        return this.loot;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockSelector)) {
            return false;
        }
        BlockSelector other = (BlockSelector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCopyState() != other.isCopyState()) {
            return false;
        }
        if (this.getWeight() != other.getWeight()) {
            return false;
        }
        Optional<BlockState> this$state = this.getState();
        Optional<BlockState> other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        Optional<Boolean> this$replace = this.getReplace();
        Optional<Boolean> other$replace = other.getReplace();
        if (this$replace == null ? other$replace != null : !((Object)this$replace).equals(other$replace)) {
            return false;
        }
        Optional<List<String>> this$copyStateProperties = this.getCopyStateProperties();
        Optional<List<String>> other$copyStateProperties = other.getCopyStateProperties();
        if (this$copyStateProperties == null ? other$copyStateProperties != null : !((Object)this$copyStateProperties).equals(other$copyStateProperties)) {
            return false;
        }
        List<IChangeCondition> this$conditions = this.getConditions();
        List<IChangeCondition> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        Optional<Vec3i> this$offset = this.getOffset();
        Optional<Vec3i> other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Optional<ResourceKey<LootTable>> this$loot = this.getLoot();
        Optional<ResourceKey<LootTable>> other$loot = other.getLoot();
        return !(this$loot == null ? other$loot != null : !((Object)this$loot).equals(other$loot));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BlockSelector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCopyState() ? 79 : 97);
        result = result * 59 + this.getWeight();
        Optional<BlockState> $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        Optional<Boolean> $replace = this.getReplace();
        result = result * 59 + ($replace == null ? 43 : ((Object)$replace).hashCode());
        Optional<List<String>> $copyStateProperties = this.getCopyStateProperties();
        result = result * 59 + ($copyStateProperties == null ? 43 : ((Object)$copyStateProperties).hashCode());
        List<IChangeCondition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        Optional<Vec3i> $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Optional<ResourceKey<LootTable>> $loot = this.getLoot();
        result = result * 59 + ($loot == null ? 43 : ((Object)$loot).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BlockSelector(state=" + String.valueOf(this.getState()) + ", replace=" + String.valueOf(this.getReplace()) + ", copyState=" + this.isCopyState() + ", copyStateProperties=" + String.valueOf(this.getCopyStateProperties()) + ", weight=" + this.getWeight() + ", conditions=" + String.valueOf(this.getConditions()) + ", offset=" + String.valueOf(this.getOffset()) + ", loot=" + String.valueOf(this.getLoot()) + ")";
    }

    @Generated
    public static class BlockSelectorBuilder {
        @Generated
        private boolean state$set;
        @Generated
        private Optional<BlockState> state$value;
        @Generated
        private boolean replace$set;
        @Generated
        private Optional<Boolean> replace$value;
        @Generated
        private boolean copyState$set;
        @Generated
        private boolean copyState$value;
        @Generated
        private boolean copyStateProperties$set;
        @Generated
        private Optional<List<String>> copyStateProperties$value;
        @Generated
        private boolean weight$set;
        @Generated
        private int weight$value;
        @Generated
        private ArrayList<IChangeCondition> conditions;
        @Generated
        private boolean offset$set;
        @Generated
        private Optional<Vec3i> offset$value;
        @Generated
        private boolean loot$set;
        @Generated
        private Optional<ResourceKey<LootTable>> loot$value;

        @Generated
        BlockSelectorBuilder() {
        }

        @Generated
        public BlockSelectorBuilder state(Optional<BlockState> state) {
            this.state$value = state;
            this.state$set = true;
            return this;
        }

        @Generated
        public BlockSelectorBuilder replace(Optional<Boolean> replace) {
            this.replace$value = replace;
            this.replace$set = true;
            return this;
        }

        @Generated
        public BlockSelectorBuilder copyState(boolean copyState) {
            this.copyState$value = copyState;
            this.copyState$set = true;
            return this;
        }

        @Generated
        public BlockSelectorBuilder copyStateProperties(Optional<List<String>> copyStateProperties) {
            this.copyStateProperties$value = copyStateProperties;
            this.copyStateProperties$set = true;
            return this;
        }

        @Generated
        public BlockSelectorBuilder weight(int weight) {
            this.weight$value = weight;
            this.weight$set = true;
            return this;
        }

        @Generated
        public BlockSelectorBuilder condition(IChangeCondition condition) {
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.add(condition);
            return this;
        }

        @Generated
        public BlockSelectorBuilder conditions(Collection<? extends IChangeCondition> conditions) {
            if (conditions == null) {
                throw new NullPointerException("conditions cannot be null");
            }
            if (this.conditions == null) {
                this.conditions = new ArrayList();
            }
            this.conditions.addAll(conditions);
            return this;
        }

        @Generated
        public BlockSelectorBuilder clearConditions() {
            if (this.conditions != null) {
                this.conditions.clear();
            }
            return this;
        }

        @Generated
        public BlockSelectorBuilder offset(Optional<Vec3i> offset) {
            this.offset$value = offset;
            this.offset$set = true;
            return this;
        }

        @Generated
        public BlockSelectorBuilder loot(Optional<ResourceKey<LootTable>> loot) {
            this.loot$value = loot;
            this.loot$set = true;
            return this;
        }

        @Generated
        public BlockSelector build() {
            List<IChangeCondition> conditions = switch (this.conditions == null ? 0 : this.conditions.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.conditions.get(0));
                default -> Collections.unmodifiableList(new ArrayList<IChangeCondition>(this.conditions));
            };
            Optional<BlockState> state$value = this.state$value;
            if (!this.state$set) {
                state$value = BlockSelector.$default$state();
            }
            Optional<Boolean> replace$value = this.replace$value;
            if (!this.replace$set) {
                replace$value = BlockSelector.$default$replace();
            }
            boolean copyState$value = this.copyState$value;
            if (!this.copyState$set) {
                copyState$value = BlockSelector.$default$copyState();
            }
            Optional<List<String>> copyStateProperties$value = this.copyStateProperties$value;
            if (!this.copyStateProperties$set) {
                copyStateProperties$value = BlockSelector.$default$copyStateProperties();
            }
            int weight$value = this.weight$value;
            if (!this.weight$set) {
                weight$value = BlockSelector.$default$weight();
            }
            Optional<Vec3i> offset$value = this.offset$value;
            if (!this.offset$set) {
                offset$value = BlockSelector.$default$offset();
            }
            Optional<ResourceKey<LootTable>> loot$value = this.loot$value;
            if (!this.loot$set) {
                loot$value = BlockSelector.$default$loot();
            }
            return new BlockSelector(state$value, replace$value, copyState$value, copyStateProperties$value, weight$value, conditions, offset$value, loot$value);
        }

        @Generated
        public String toString() {
            return "BlockSelector.BlockSelectorBuilder(state$value=" + String.valueOf(this.state$value) + ", replace$value=" + String.valueOf(this.replace$value) + ", copyState$value=" + this.copyState$value + ", copyStateProperties$value=" + String.valueOf(this.copyStateProperties$value) + ", weight$value=" + this.weight$value + ", conditions=" + String.valueOf(this.conditions) + ", offset$value=" + String.valueOf(this.offset$value) + ", loot$value=" + String.valueOf(this.loot$value) + ")";
        }
    }
}

