/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.weather;

import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.climate.FlatRain;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.solar.TimePeriod;
import com.teamtea.eclipticseasons.api.data.weather.CustomRainBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.Level;

public record CustomRain(int ordinal, List<Weather> weatherList, Optional<BiomeRain> defaultWeather, float rainChance, float thunderChance) implements BiomeRain
{
    @Override
    public float getRainChance() {
        return this.defaultWeather.map(BiomeRain::getRainChance).orElseGet(this::rainChance).floatValue();
    }

    @Override
    public float getThunderChance() {
        return this.defaultWeather.map(BiomeRain::getThunderChance).orElseGet(this::thunderChance).floatValue();
    }

    @Override
    public int getRainDuration(RandomSource random) {
        return this.defaultWeather.map(biomeRain -> biomeRain.getRainDuration(random)).orElseGet(() -> BiomeRain.super.getRainDuration(random));
    }

    @Override
    public int getRainDelay(RandomSource random) {
        return this.defaultWeather.map(biomeRain -> biomeRain.getRainDelay(random)).orElseGet(() -> BiomeRain.super.getRainDelay(random));
    }

    @Override
    public int getThunderDuration(RandomSource random) {
        return this.defaultWeather.map(biomeRain -> biomeRain.getThunderDuration(random)).orElseGet(() -> BiomeRain.super.getThunderDuration(random));
    }

    @Override
    public int getThunderDelay(RandomSource random) {
        return this.defaultWeather.map(biomeRain -> biomeRain.getThunderDelay(random)).orElseGet(() -> BiomeRain.super.getThunderDelay(random));
    }

    @Override
    public BiomeRain resolve(Level level) {
        if (this.defaultWeather.isPresent()) {
            return this.defaultWeather.get();
        }
        if (this.weatherList.isEmpty()) {
            return FlatRain.NONE;
        }
        TimePeriod timePeriod = TimePeriod.fromTimeOfDay(level.getTimeOfDay(1.0f));
        ArrayList<Weather> selectList = new ArrayList<Weather>();
        for (Weather weather : this.weatherList) {
            if (!weather.timePeriod().isEmpty() && !weather.timePeriod().contains(timePeriod)) continue;
            selectList.add(weather);
        }
        if (selectList.isEmpty()) {
            return FlatRain.NONE;
        }
        return (BiomeRain)selectList.get(level.getRandom().nextInt(selectList.size()));
    }

    public record Weather(int ordinal, Optional<IntProvider> rain, Optional<IntProvider> rainDelay, Optional<IntProvider> thunder, Optional<IntProvider> thunderDelay, float rainChance, float thunderChance, List<TimePeriod> timePeriod) implements BiomeRain
    {
        public static Weather of(SolarTerm solarTerm, CustomRainBuilder.Weather weather) {
            return new Weather(solarTerm.ordinal(), weather.rain(), weather.rainDelay(), weather.thunder(), weather.thunderDelay(), weather.rainChance(), weather.thunderChance(), weather.timePeriod());
        }

        @Override
        public float getThunderChance() {
            return this.thunderChance();
        }

        @Override
        public float getRainChance() {
            return this.rainChance();
        }

        @Override
        public int getRainDuration(RandomSource random) {
            return this.rain.map(provider -> provider.sample(random)).orElseGet(() -> BiomeRain.super.getRainDuration(random));
        }

        @Override
        public int getRainDelay(RandomSource random) {
            return this.rainDelay.map(provider -> provider.sample(random)).orElseGet(() -> BiomeRain.super.getRainDelay(random));
        }

        @Override
        public int getThunderDuration(RandomSource random) {
            return this.thunder.map(provider -> provider.sample(random)).orElseGet(() -> BiomeRain.super.getThunderDuration(random));
        }

        @Override
        public int getThunderDelay(RandomSource random) {
            return this.thunderDelay.map(provider -> provider.sample(random)).orElseGet(() -> BiomeRain.super.getThunderDelay(random));
        }
    }
}

