/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.weather;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.climate.ISnowTerm;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;

public record CustomSnowTerm(HolderSet<Biome> biomes, SolarTerm start, SolarTerm end, List<TempEvent> tempEvents) implements ISnowTerm
{
    public static final Codec<CustomSnowTerm> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)CodecUtil.holderSetCodec(Registries.BIOME).fieldOf("biomes").forGetter(CustomSnowTerm::biomes), (App)ESExtraCodec.SOLAR_TERM.fieldOf("start").forGetter(CustomSnowTerm::start), (App)ESExtraCodec.SOLAR_TERM.fieldOf("end").forGetter(CustomSnowTerm::end), (App)TempEvent.CODEC.listOf().optionalFieldOf("events", List.of()).forGetter(CustomSnowTerm::tempEvents)).apply((Applicative)ins, CustomSnowTerm::new));

    @Override
    public SolarTerm getStart() {
        return this.start;
    }

    @Override
    public SolarTerm getEnd() {
        return this.end;
    }

    @Override
    public ISnowTerm cast(float tempChange) {
        for (TempEvent tempEvent : this.tempEvents) {
            if (!(tempEvent.tempOffset > tempChange)) continue;
            return tempEvent;
        }
        return this;
    }

    public record TempEvent(float tempOffset, SolarTerm start, SolarTerm end) implements ISnowTerm
    {
        public static final Codec<TempEvent> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.FLOAT.fieldOf("temp_offset").forGetter(TempEvent::tempOffset), (App)ESExtraCodec.SOLAR_TERM.fieldOf("start").forGetter(TempEvent::start), (App)ESExtraCodec.SOLAR_TERM.fieldOf("end").forGetter(TempEvent::end)).apply((Applicative)ins, TempEvent::new));

        @Override
        public SolarTerm getStart() {
            return this.start();
        }

        @Override
        public SolarTerm getEnd() {
            return this.end();
        }
    }
}

