/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util;

import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class WeatherUtil {
    public static boolean isBlockInRainOrSnow(Level level, BlockPos blockPos) {
        for (BlockPos pos : List.of(blockPos.above(), blockPos.north(), blockPos.south(), blockPos.east(), blockPos.west())) {
            if (!WeatherManager.isRainingOrSnowAtBiome(level, MapChecker.getSurfaceBiome(level, pos))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityInRainOrSnow(LivingEntity entity) {
        BlockPos blockPos = entity.blockPosition();
        BlockPos pos2 = BlockPos.containing((double)blockPos.getX(), (double)entity.getBoundingBox().maxY, (double)blockPos.getZ());
        return WeatherManager.isRainingOrSnowAt(entity.level(), blockPos) || WeatherManager.isRainingOrSnowAt(entity.level(), pos2);
    }
}

