/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util.manage;

import java.util.concurrent.ConcurrentLinkedQueue;

public class SimpleObjectPool<T extends AutoCloseable> {
    private final ConcurrentLinkedQueue<T> pool = new ConcurrentLinkedQueue();
    private final ObjectFactory<T> factory;
    private final int maxSize;

    public SimpleObjectPool(ObjectFactory<T> factory, int maxSize) {
        this.factory = factory;
        this.maxSize = maxSize;
    }

    public T acquire() throws Exception {
        AutoCloseable obj = (AutoCloseable)this.pool.poll();
        return (T)(obj == null ? (AutoCloseable)this.factory.create() : obj);
    }

    public void release(T obj) {
        if (obj == null) {
            return;
        }
        if (this.pool.size() < this.maxSize) {
            this.pool.offer(obj);
        } else {
            try {
                obj.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int size() {
        return this.pool.size();
    }

    public void closeAll() {
        while (!this.pool.isEmpty()) {
            try {
                ((AutoCloseable)this.pool.poll()).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static interface ObjectFactory<T> {
        public T create() throws Exception;
    }
}

