/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.misc.ESSortInfo;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.color.season.BiomeColorsHandler;
import com.teamtea.eclipticseasons.client.core.ClientWeatherChecker;
import com.teamtea.eclipticseasons.client.render.WorldRenderer;
import com.teamtea.eclipticseasons.client.render.chunk.CompilerCollector;
import com.teamtea.eclipticseasons.client.render.chunk.IceKeeper;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.client.util.ClientRef;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.BiomeClimateManager;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.crop.CropInfoManager;
import com.teamtea.eclipticseasons.common.core.crop.NaturalPlantHandler;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.snow.SnowChecker;
import com.teamtea.eclipticseasons.common.core.solar.ClientSolarDataManager;
import com.teamtea.eclipticseasons.common.game.AnimalHooks;
import com.teamtea.eclipticseasons.common.misc.MapExporter;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.config.ClientConfig;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="eclipticseasons", value={Dist.CLIENT})
public final class ClientEventHandler {
    private static long lastFreshTime = -1L;
    public static float prevFogDensity = -1.0f;
    public static long prevFogTick = -1L;
    public static float r = 0.0f;
    public static float g = 0.0f;
    public static float b = 0.0f;

    @SubscribeEvent
    public static void onRenderTick(ClientTickEvent.Post event) {
        if (Minecraft.getInstance().player != null) {
            WorldRenderer.applyEffect(Minecraft.getInstance().gameRenderer, Minecraft.getInstance().player);
        }
        if (BiomeColorsHandler.needRefresh) {
            BiomeColorsHandler.reloadColors();
        }
    }

    @SubscribeEvent
    public static void addTooltips(ItemTooltipEvent event) {
        if (((Boolean)ClientConfig.GUI.agriculturalInformation.get()).booleanValue()) {
            BlockItem blockItem;
            Item item = event.getItemStack().getItem();
            if (item instanceof BlockItem) {
                blockItem = (BlockItem)item;
                event.getToolTip().addAll(CropGrowthHandler.appendInfo(event.getContext().level(), blockItem.getBlock().defaultBlockState()));
            } else {
                event.getToolTip().addAll(CropInfoManager.appendInfo(event.getItemStack().getItem()));
            }
            item = event.getItemStack().getItem();
            if (item instanceof SpawnEggItem) {
                blockItem = (SpawnEggItem)item;
                event.getToolTip().addAll(AnimalHooks.getBreedInfo(blockItem.getType(event.getItemStack())));
            }
        }
    }

    @SubscribeEvent
    public static void addTooltips(RenderTooltipEvent.GatherComponents event) {
        if (event.getItemStack().getItem() instanceof BlockItem && ClientConfig.GUI.agriculturalInformation.getAsBoolean()) {
            Object info;
            if (!((Boolean)CommonConfig.Crop.enableCropHumidityControl.get()).booleanValue() || !CropInfoManager.getHumidityCrops().contains(((BlockItem)event.getItemStack().getItem()).getBlock()) || (info = CropInfoManager.getHumidityInfo(((BlockItem)event.getItemStack().getItem()).getBlock())) != null) {
                // empty if block
            }
            if (!((Boolean)CommonConfig.Crop.enableCrop.get()).booleanValue() || !CropInfoManager.getSeasonCrops().contains(((BlockItem)event.getItemStack().getItem()).getBlock()) || (info = CropInfoManager.getSeasonInfo(((BlockItem)event.getItemStack().getItem()).getBlock())) != null) {
                // empty if block
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnloadEvent(ChunkEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            CompilerCollector.clearChunk(event.getChunk().getPos());
        }
    }

    @SubscribeEvent
    public static void onLevelUnloadEvent(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)levelAccessor;
            ClientCon.setUseLevel(null);
            ClientWeatherChecker.unloadLevel((Level)clientLevel);
            CompilerCollector.clearAll();
            IceKeeper.clearAll();
        }
    }

    @SubscribeEvent
    public static void onPlayerExit(ClientPlayerNetworkEvent.LoggingOut event) {
        if (Minecraft.getInstance().player != null) {
            CropGrowthHandler.clearOnClientExitOrServerClose();
            NaturalPlantHandler.clearOnClientExitOrServerClose();
            BiomeClimateManager.clearOnClientExitOrServerClose();
            SnowChecker.clearOnClientExitOrServerClose();
            ClientRef.onClientPlayerExit();
            ClientCon.onClientPlayerExit();
            ESSortInfo.clearOnClientExitOrServerClose();
        }
    }

    @SubscribeEvent
    public static void onLevelEventLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            if (((List)CommonConfig.Season.validDimensions.get()).contains(level.dimension().location().toString())) {
                MapChecker.validDimension.add((Level)level);
            }
            ClientCon.setUseLevel((Level)level);
            ClientCon.tick((Level)level);
            WeatherManager.createLevelBiomeWeatherList((Level)level);
            SolarHolders.createSaveData((Level)level, ClientSolarDataManager.get(level));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(EntityTickEvent.Post event) {
        if (event.getEntity().level() instanceof ClientLevel) {
            IceKeeper.checkIfPlayerStepInFrozenWater(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            ClientWeatherChecker.tickAllCheck((Level)clientLevel);
            ClientCon.tick((Level)clientLevel);
            if (!(EclipticUtil.canSnowyBlockInteract() && !((Boolean)ClientConfig.Renderer.enhancementChunkRenderUpdate.get()).booleanValue() || !((Boolean)ClientConfig.Renderer.forceChunkRenderUpdate.get()).booleanValue() || clientLevel.getGameTime() - lastFreshTime <= 80L && clientLevel.getGameTime() >= lastFreshTime - 1L)) {
                lastFreshTime = clientLevel.getGameTime();
                Entity entity = Minecraft.getInstance().cameraEntity;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    BlockPos pos = player.getOnPos();
                    SectionPos sectionPos = SectionPos.of((BlockPos)pos);
                    if (!((Boolean)ClientConfig.Renderer.enhancementChunkRenderUpdate.get()).booleanValue()) {
                        WorldRenderer.setSectionDirtyWithNeighbors(sectionPos);
                        WorldRenderer.setSectionDirtyRandomly(sectionPos);
                    } else if (clientLevel.getRandom().nextInt(2) == 0) {
                        WorldRenderer.setAllDirty(sectionPos);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onFogEvent(ViewportEvent.ComputeFogColor event) {
    }

    @SubscribeEvent
    public static void onFogEvent(ViewportEvent.RenderFog event) {
    }

    @SubscribeEvent
    public static void onRenderLevelStageEvent(RenderLevelStageEvent event) {
    }

    @SubscribeEvent
    public static void onAddSectionGeometryEvent(AddSectionGeometryEvent event) {
    }

    @SubscribeEvent
    public static void onRegisterClientCommandsEvent(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"ecliptic").then(((LiteralArgumentBuilder)Commands.literal((String)"c_export").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(stackCommandContext -> MapExporter.exportMap((CommandSourceStack)stackCommandContext.getSource(), BlockPosArgument.getBlockPos((CommandContext)stackCommandContext, (String)"pos"))))));
    }

    @SubscribeEvent
    public static void onRegisterClientCommandsEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientCon.ServerName = event.getPlayer().connection.getServerData() == null ? "Client" : event.getPlayer().connection.getServerData().name;
    }

    @SubscribeEvent
    public static void onTagsUpdatedEvent(TagsUpdatedEvent tagsUpdatedEvent) {
        if (tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            ClientRef.updateClientSide(tagsUpdatedEvent.getRegistryAccess());
        }
    }

    private static /* synthetic */ void lambda$onAddSectionGeometryEvent$0(AddSectionGeometryEvent event, AddSectionGeometryEvent.SectionRenderingContext context) {
        RenderType type = ItemBlockRenderTypes.getRenderLayer((FluidState)Fluids.WATER.defaultFluidState());
        VertexConsumer buffer = context.getOrCreateChunkBuffer(RenderType.cutoutMipped());
        PoseStack poseStack = context.getPoseStack();
        poseStack.pushPose();
        BlockPos pos = event.getSectionOrigin();
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((Fluid)Fluids.WATER).getStillTexture());
        still = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(EclipticSeasons.rl("block/snow_overlay_2"));
        int color = IClientFluidTypeExtensions.of((Fluid)Fluids.WATER).getTintColor();
        color = Color.WHITE.getRGB();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = color >> 24 & 0xFF;
        float height = 1.0f;
        int light = 0xF000F0;
        light = LevelRenderer.getLightColor((BlockAndTintGetter)context.getRegion(), (BlockPos)pos);
        light = 0xF000F0;
        if (!context.getRegion().getBlockState(pos).isEmpty()) {
            Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), buffer, null, Minecraft.getInstance().getModelManager().getModel(BlockModelShaper.stateToModelLocation((BlockState)((Block)BlockRegistry.snowyLeaves.get()).defaultBlockState())), 1.0f, 1.0f, 1.0f, light, 0, ModelData.EMPTY, RenderType.cutoutMipped());
        }
        poseStack.popPose();
    }

    public static class mccc
    implements TooltipComponent {
    }

    public static class ccc
    implements ClientTooltipComponent {
        public ccc(mccc ccc2) {
        }

        public int getHeight() {
            return 18;
        }

        public int getWidth(Font font) {
            return 16;
        }

        public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
            guiGraphics.renderItem(Items.APPLE.getDefaultInstance(), x + 0, y + 1, 0);
        }
    }
}

