/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.core;

import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.misc.SimplePair;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ClientWeatherChecker {
    public static final List<SimplePair<Biome, Long>> lastRainyBiome = new ArrayList<SimplePair<Biome, Long>>();
    public static float lastBiomeRainLevel = -1.0f;
    public static float lastBiomeRThunderLevel = -1.0f;
    public static float nowBiomeRainLevel = 0.0f;
    public static int changeTime = 0;
    public static long lastTime = 0L;
    public static int changeTime_thunder = 0;
    public static int MAX_CHANGE_TIME = 200;
    public static boolean updateForPlayerLogin = true;
    public static float rate = 0.008f;

    private static boolean isNear(float a, float b, float interval) {
        return Math.abs(a - b) < interval;
    }

    public static float getRate() {
        return ((Double)ClientConfig.Weather.weatherTransitionSpeed.get()).floatValue();
    }

    public static boolean isRain(Level clientLevel) {
        return (double)ClientWeatherChecker.getRainLevel(clientLevel, 1.0f) > 0.2;
    }

    public static float getStandardRainLevel(float p46723, Level clientLevel, Holder<Biome> biomeHolder) {
        WeatherManager.BiomeWeather biomeWeather = WeatherManager.getBiomeWeather(clientLevel, biomeHolder);
        return biomeWeather != null ? (biomeWeather.rainTime > 0 ? 1.0f : 0.0f) : 0.0f;
    }

    public static float getRainLevel(Level clientLevel, float p46723) {
        if (updateForPlayerLogin && ClientCon.agent.getCameraEntity() instanceof Player) {
            updateForPlayerLogin = false;
            lastBiomeRainLevel = -1.0f;
        }
        if (lastBiomeRainLevel < 0.0f) {
            float f;
            Entity entity = ClientCon.agent.getCameraEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                f = ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, player.getOnPos().above()));
            } else {
                f = ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, null);
            }
            lastBiomeRainLevel = f;
        }
        return lastBiomeRainLevel;
    }

    public static float updateRainLevel(Level clientLevel) {
        float rainLevel = ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, null);
        Entity entity = ClientCon.agent.getCameraEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos pos = player.getOnPos();
            int offset = ClientConfig.Weather.weatherBufferDistance.getAsInt();
            boolean frontUse = (Boolean)ClientConfig.Weather.weatherFrontBias.get();
            rainLevel = ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, pos));
            float count = 1.0f;
            if (frontUse && ClientCon.agent.getHitResult() != null) {
                BlockPos[] lookAt = ClientCon.agent.getHitResult().getLocation();
                Vec3 crs2 = lookAt.subtract(ClientCon.agent.getCameraEntity().position());
                lookAt = lookAt.add(crs2.normalize().scale((double)offset));
                BlockPos lookPos = BlockPos.containing((Position)lookAt);
                rainLevel += ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, lookPos)) * 2.0f;
                count += 2.0f;
            }
            for (BlockPos blockPos : new BlockPos[]{pos.east(offset), pos.north(offset), pos.south(offset), pos.west(offset)}) {
                Holder<Biome> standBiome = MapChecker.getSurfaceBiome(clientLevel, blockPos);
                float orainLevel = ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, standBiome);
                rainLevel += orainLevel;
                count += 1.0f;
            }
            rainLevel /= count;
            if (changeTime > 0) {
                --changeTime;
                if (lastBiomeRainLevel >= 0.0f && !ClientWeatherChecker.isNear(rainLevel, lastBiomeRainLevel, 0.01f)) {
                    float add = ClientWeatherChecker.getRate() * (float)(rainLevel - lastBiomeRainLevel > 0.0f ? 1 : -1);
                    rainLevel = lastBiomeRainLevel += add;
                }
                lastBiomeRainLevel = rainLevel;
                lastBiomeRainLevel = Mth.clamp((float)rainLevel, (float)0.0f, (float)1.0f);
            } else if (rainLevel != lastBiomeRainLevel) {
                changeTime = MAX_CHANGE_TIME;
                rainLevel = lastBiomeRainLevel;
            }
        }
        return rainLevel;
    }

    public static float getStandardThunderLevel(float p46723, Level clientLevel, Holder<Biome> biomeHolder) {
        WeatherManager.BiomeWeather biomeWeather = WeatherManager.getBiomeWeather(clientLevel, biomeHolder);
        return biomeWeather != null ? (biomeWeather.thunderTime > 0 ? 1.0f : 0.0f) : 0.0f;
    }

    public static boolean isThundering(Level clientLevel) {
        return (double)ClientWeatherChecker.getThunderLevel(clientLevel, 1.0f) > 0.2;
    }

    public static float getThunderLevel(Level clientLevel, float p46723) {
        if (updateForPlayerLogin && ClientCon.agent.getCameraEntity() instanceof Player) {
            lastBiomeRainLevel = -1.0f;
        }
        if (lastBiomeRThunderLevel < 0.0f) {
            float f;
            Entity entity = ClientCon.agent.getCameraEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                f = ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, player.getOnPos().above()));
            } else {
                f = ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, null);
            }
            lastBiomeRThunderLevel = f;
        }
        return lastBiomeRThunderLevel;
    }

    public static float updateThunderLevel(Level clientLevel) {
        float thunderLevel = ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, null);
        Entity entity = ClientCon.agent.getCameraEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos pos = player.getOnPos();
            int offset = ClientConfig.Weather.weatherBufferDistance.getAsInt();
            boolean frontUse = (Boolean)ClientConfig.Weather.weatherFrontBias.get();
            thunderLevel = ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, pos));
            float count = 1.0f;
            if (frontUse && ClientCon.agent.getHitResult() != null) {
                BlockPos[] lookAt = ClientCon.agent.getHitResult().getLocation();
                Vec3 crs2 = lookAt.subtract(ClientCon.agent.getCameraEntity().position());
                lookAt = lookAt.add(crs2.normalize().scale((double)offset));
                BlockPos lookPos = BlockPos.containing((Position)lookAt);
                thunderLevel += ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, lookPos)) * 2.0f;
                count += 2.0f;
            }
            for (BlockPos blockPos : new BlockPos[]{pos.east(offset), pos.north(offset), pos.south(offset), pos.west(offset)}) {
                Holder<Biome> standBiome = MapChecker.getSurfaceBiome(clientLevel, blockPos);
                float othunderLevel = ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, standBiome);
                thunderLevel += othunderLevel;
                count += 1.0f;
            }
            thunderLevel /= count;
            if (changeTime_thunder > 0) {
                --changeTime_thunder;
                if (lastBiomeRThunderLevel >= 0.0f && !ClientWeatherChecker.isNear(thunderLevel, lastBiomeRThunderLevel, 0.01f)) {
                    float add = ClientWeatherChecker.getRate() * (float)(thunderLevel - lastBiomeRThunderLevel > 0.0f ? 1 : -1);
                    thunderLevel = lastBiomeRThunderLevel += add;
                }
                lastBiomeRThunderLevel = Mth.clamp((float)thunderLevel, (float)0.0f, (float)1.0f);
            } else if (thunderLevel != lastBiomeRThunderLevel) {
                changeTime_thunder = MAX_CHANGE_TIME;
                thunderLevel = lastBiomeRThunderLevel;
            }
        }
        return thunderLevel;
    }

    public static boolean isRainingAt(@NotNull Level clientLevel, BlockPos blockPos) {
        if (!clientLevel.canSeeSky(blockPos)) {
            return false;
        }
        if (clientLevel.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).getY() > blockPos.getY()) {
            return false;
        }
        return EclipticUtil.getRainOrSnow(clientLevel, (Biome)MapChecker.getSurfaceBiome(clientLevel, blockPos).value(), blockPos) == Biome.Precipitation.RAIN;
    }

    public static boolean isThunderAt(Level clientLevel, BlockPos blockPos) {
        if (!clientLevel.canSeeSky(blockPos)) {
            return false;
        }
        if (clientLevel.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).getY() > blockPos.getY()) {
            return false;
        }
        return ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, blockPos)) > 0.9f;
    }

    public static int ModifySnowAmount(int constant, float pPartialTick, Level level) {
        if (level == null) {
            return constant;
        }
        return (int)((float)constant * Mth.clamp((float)(level.getRainLevel(pPartialTick) * 0.6f), (float)0.6f, (float)1.0f));
    }

    public static float modifyVolume(SoundEvent soundEvent, float pVolume, Level level) {
        if (level == null) {
            return pVolume;
        }
        return pVolume * level.getRainLevel(1.0f) * 0.55f;
    }

    public static float modifyPitch(SoundEvent soundEvent, float pPitch, Level level) {
        if (level == null) {
            return pPitch;
        }
        return pPitch * level.getRainLevel(1.0f);
    }

    public static int modifyRainAmount(int originalNum, Level level) {
        if (level == null) {
            return originalNum;
        }
        return (int)((float)originalNum * level.getRainLevel(1.0f) * 0.6f);
    }

    public static void unloadLevel(Level clientLevel) {
        lastBiomeRThunderLevel = -1.0f;
        lastBiomeRainLevel = -1.0f;
        updateForPlayerLogin = true;
        lastRainyBiome.clear();
    }

    public static void tickAllCheck(Level clientLevel) {
        ClientWeatherChecker.updateRainLevel(clientLevel);
        ClientWeatherChecker.updateThunderLevel(clientLevel);
        ClientWeatherChecker.tickLastRainyBiome(clientLevel);
    }

    public static void addLastRainyBiome(Biome biome, long gameTime) {
        lastRainyBiome.removeIf(biomeLongSimplePair -> biomeLongSimplePair.getKey() == biome);
        lastRainyBiome.add(SimplePair.of(biome, gameTime));
    }

    public static boolean isBiomeRainyLast(Biome biome) {
        for (int i = 0; i < lastRainyBiome.size(); ++i) {
            SimplePair<Biome, Long> biomeLongSimplePair = lastRainyBiome.get(i);
            if (biomeLongSimplePair.getKey() != biome) continue;
            return true;
        }
        return false;
    }

    public static void tickLastRainyBiome(Level clientLevel) {
        for (int i = 0; i < lastRainyBiome.size(); ++i) {
            SimplePair<Biome, Long> biomeLongSimplePair = lastRainyBiome.get(i);
            biomeLongSimplePair.setValue(biomeLongSimplePair.getValue() - 1L);
            if (biomeLongSimplePair.getValue() > 0L) continue;
            lastRainyBiome.remove(i);
            --i;
        }
    }
}

