/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.debug;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public final class DebugInfoRenderer {
    private final Minecraft mc;
    private long delay = 0L;
    private Holder<Biome> biomeHolder;

    public DebugInfoRenderer(Minecraft mc) {
        this.mc = mc;
    }

    public void renderStatusBar(GuiGraphics matrixStack, int screenWidth, int screenHeight, ClientLevel clientLevel, LocalPlayer player, String solar, long dayTime, double env, int solarTime) {
        WeatherManager.BiomeWeather biomeWeather;
        Holder<Biome> standBiome;
        BlockPos pos = player.blockPosition();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        String solarS = "Solar Terms Day: " + solar;
        String dayS = "Day Time: " + dayTime;
        String envS = "Env Temp: " + env;
        String solarTimeS = "Solar Time: " + solarTime;
        Holder biome = clientLevel.getBiome(player.getOnPos());
        String dS = "Downfall: " + String.valueOf(EclipticUtil.getRainfallAt((Level)clientLevel, pos));
        String jS = "Humidity: " + String.valueOf(EclipticUtil.getHumidityAt((Level)clientLevel, pos)) + "\n" + EclipticUtil.getHumidityLevelAt(player.level(), player.blockPosition());
        String ys = "y: " + MapChecker.getHeight((Level)clientLevel, pos);
        int index = 0;
        this.drawInfo(matrixStack, screenWidth, screenHeight, solarS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, dayS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, envS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, dS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, jS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, solarTimeS, index++);
        this.drawInfo(matrixStack, screenWidth, screenHeight, ys, index++);
        ClientLevel level1 = Minecraft.getInstance().level;
        Holder<Biome> holder = standBiome = this.biomeHolder == null || this.delay == 0L ? level1.getBiome(player.getOnPos()) : this.biomeHolder;
        if (this.delay == 0L) {
            this.delay = 100L;
        }
        if ((biomeWeather = WeatherManager.getBiomeWeather((Level)level1, standBiome)) != null) {
            SolarTerm solarTerm = ClientCon.nowSolarTerm;
            String biomesS = "Biome: " + Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)ResourceLocation.parse((String)standBiome.getRegisteredName()))).getString();
            String biomesSS = "E-Biome: " + Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)ResourceLocation.parse((String)MapChecker.getSurfaceBiome((Level)level1, pos).getRegisteredName()))).getString();
            String solarTermS = "Solar Term: " + solarTerm.getTranslation().getString();
            String biomeRainS = "Biome Rain: " + String.valueOf(solarTerm.getBiomeRain(biomeWeather.biomeHolder));
            String snowTermS = "Snow Term: " + String.valueOf(SolarTerm.getSnowTerm((Biome)biomeWeather.biomeHolder.value(), true, EclipticUtil.getSnowTempChange((Level)level1)));
            this.drawInfo(matrixStack, screenWidth, screenHeight, "", index++);
            this.drawInfo(matrixStack, screenWidth, screenHeight, biomesS, index++);
            this.drawInfo(matrixStack, screenWidth, screenHeight, biomesSS, index++);
            this.drawInfo(matrixStack, screenWidth, screenHeight, solarTermS, index++);
            this.drawInfo(matrixStack, screenWidth, screenHeight, biomeRainS, index++);
            this.drawInfo(matrixStack, screenWidth, screenHeight, snowTermS, index++);
            this.drawInfo(matrixStack, screenWidth, screenHeight, "", index++);
            String rainTimeS = "Rain Time: " + biomeWeather.rainTime;
            String clearTimeS = "Clear Time: " + biomeWeather.clearTime;
            String thunderTimeS = "Thunder Time: " + biomeWeather.thunderTime;
            String snowDepthS = "Snow Depth: " + biomeWeather.snowDepth;
            this.drawInfo(matrixStack, screenWidth, screenHeight, rainTimeS, index++);
            this.drawInfo(matrixStack, screenWidth, screenHeight, clearTimeS, index++);
            this.drawInfo(matrixStack, screenWidth, screenHeight, thunderTimeS, index++);
            this.drawInfo(matrixStack, screenWidth, screenHeight, snowDepthS, index++);
        }
        RenderSystem.enableBlend();
    }

    private void drawInfo(GuiGraphics matrixStack, int screenWidth, int screenHeight, String s, int index) {
        if (s.isEmpty()) {
            return;
        }
        matrixStack.drawString(this.mc.font, s, screenWidth / 2 - this.mc.font.width(s) / 2, index * 9 + 3, 0xFFFFFF);
    }
}

