/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.debug;

import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.debug.DebugInfoRenderer;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.solar.SolarAngelHelper;
import com.teamtea.eclipticseasons.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="eclipticseasons")
public final class OverlayEventHandler {
    public static final ResourceLocation DEFAULT = ResourceLocation.withDefaultNamespace((String)"textures/gui/icons.png");
    private static final DebugInfoRenderer BAR_4 = new DebugInfoRenderer(Minecraft.getInstance());

    @SubscribeEvent(receiveCanceled=true)
    public static void onEvent(RenderGuiEvent.Post event) {
        LocalPlayer clientPlayer = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (clientPlayer != null && level != null && ((Boolean)ClientConfig.Debug.debugInfo.get()).booleanValue() && !Minecraft.getInstance().options.hideGui) {
            Level level1 = clientPlayer.level();
            BlockPos onPos = clientPlayer.blockPosition();
            int solar = SolarHolders.getSaveDataLazy(level1).get().getSolarTermsDay();
            long dayTime = level1.getDayTime();
            double env = EclipticUtil.getTemperatureFloat(level1, (Biome)level1.getBiome(onPos).value(), onPos);
            int solarTime = SolarAngelHelper.getSolarAngelTime((LevelTimeAccess)level1, level1.getDayTime());
            BAR_4.renderStatusBar(event.getGuiGraphics(), Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight(), level, clientPlayer, "" + solar, dayTime, env, solarTime);
        }
    }
}

