/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.client.core.ExtraModelManager;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.compat.vanilla.IExtendBlockView;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeasonGoingModel<T extends BakedModel>
extends BakedModelWrapper<T> {
    public static final ModelProperty<Boolean> SNOW_PROPERTY = new ModelProperty();
    private final Map<SolarTerm, List<Pair<T, T>>> models;
    private final Map<SolarTerm, List<Pair<T, T>>> snowModels;

    public SeasonGoingModel(T originalModel, Map<SolarTerm, List<Pair<T, T>>> models, Map<SolarTerm, List<Pair<T, T>>> snowModels) {
        super(originalModel);
        this.models = models;
        this.snowModels = snowModels;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        List<Pair<T, T>> bakedModels;
        if (state != null && (bakedModels = (extraData.has(SNOW_PROPERTY) ? this.snowModels : this.models).get(ClientCon.nowSolarTerm)) != null && !bakedModels.isEmpty()) {
            Pair<T, T> pair;
            Pair<T, T> pair2 = pair = bakedModels.size() == 1 ? bakedModels.get(0) : bakedModels.get(rand.nextInt(bakedModels.size()));
            if (pair.getFirst() == pair.getSecond()) {
                return ((BakedModel)pair.getFirst()).getQuads(state, side, rand, extraData, renderType);
            }
            return (rand.nextInt(100) >= ClientCon.progress ? (BakedModel)pair.getFirst() : (BakedModel)pair.getSecond()).getQuads(state, side, rand, extraData, renderType);
        }
        return super.getQuads(state, side, rand, extraData, renderType);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, BlockState state, ModelData modelData) {
        BlockPos.MutableBlockPos mutableBlockPos;
        ModelData modelData1 = super.getModelData(level, pos, state, modelData);
        long l = state.getSeed(pos);
        if (level instanceof IExtendBlockView) {
            IExtendBlockView extendBlockView = (IExtendBlockView)level;
            mutableBlockPos = extendBlockView.getModelCheckPos();
        } else {
            mutableBlockPos = null;
        }
        if (ExtraModelManager.canSnowy(level, pos, state, l, mutableBlockPos)) {
            modelData1 = modelData1.derive().with(SNOW_PROPERTY, (Object)true).build();
        }
        return modelData1;
    }
}

