/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model.bakequad;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class BakedQuadRetexturedAndReUV
extends BakedQuad {
    private final TextureAtlasSprite texture;
    public static int uvIndex = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV0) / 4;
    public static int verticeSpace = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
    private final boolean isSlabDown;
    private final float offset;

    public BakedQuadRetexturedAndReUV(BakedQuad quad, TextureAtlasSprite textureIn, boolean isSlabDown) {
        this(quad, textureIn, isSlabDown, 0.5f);
    }

    public BakedQuadRetexturedAndReUV(BakedQuad quad, TextureAtlasSprite textureIn, boolean isSlabDown, float offset) {
        super(Arrays.copyOf(quad.getVertices(), quad.getVertices().length), quad.getTintIndex(), quad.getDirection(), quad.getSprite(), quad.isShade(), quad.hasAmbientOcclusion());
        this.texture = textureIn;
        this.isSlabDown = isSlabDown;
        this.offset = offset;
        this.remapQuad();
    }

    private void remapQuad() {
        float x0 = Float.intBitsToFloat(this.vertices[0]);
        float y0 = Float.intBitsToFloat(this.vertices[1]);
        float z0 = Float.intBitsToFloat(this.vertices[2]);
        float x1 = Float.intBitsToFloat(this.vertices[verticeSpace]);
        float y1 = Float.intBitsToFloat(this.vertices[verticeSpace + 1]);
        float z1 = Float.intBitsToFloat(this.vertices[verticeSpace + 2]);
        float x3 = Float.intBitsToFloat(this.vertices[3 * verticeSpace]);
        float y3 = Float.intBitsToFloat(this.vertices[3 * verticeSpace + 1]);
        float z3 = Float.intBitsToFloat(this.vertices[3 * verticeSpace + 2]);
        float edge1X = x1 - x0;
        float edge1Y = y1 - y0;
        float edge1Z = z1 - z0;
        float edge2X = x3 - x0;
        float edge2Y = y3 - y0;
        float edge2Z = z3 - z0;
        float lenU = (float)Math.sqrt(edge2X * edge2X + edge2Y * edge2Y + edge2Z * edge2Z);
        float lenV = (float)Math.sqrt(edge1X * edge1X + edge1Y * edge1Y + edge1Z * edge1Z);
        for (int i = 0; i < 4; ++i) {
            int j = verticeSpace * i;
            float x = Float.intBitsToFloat(this.vertices[j]);
            float y = Float.intBitsToFloat(this.vertices[j + 1]);
            float z = Float.intBitsToFloat(this.vertices[j + 2]);
            float du = ((x - x0) * edge2X + (y - y0) * edge2Y + (z - z0) * edge2Z) / (edge2X * edge2X + edge2Y * edge2Y + edge2Z * edge2Z);
            float dv = ((x - x0) * edge1X + (y - y0) * edge1Y + (z - z0) * edge1Z) / (edge1X * edge1X + edge1Y * edge1Y + edge1Z * edge1Z);
            du *= lenU;
            dv *= lenV;
            du = Mth.clamp((float)du, (float)0.0f, (float)1.0f);
            dv = Mth.clamp((float)dv, (float)0.0f, (float)1.0f);
            this.vertices[j + BakedQuadRetexturedAndReUV.uvIndex] = Float.floatToRawIntBits(this.texture.getU(du));
            this.vertices[j + BakedQuadRetexturedAndReUV.uvIndex + 1] = Float.floatToRawIntBits(this.texture.getV(dv));
        }
    }

    private void remapQuadOld() {
        Direction direction1 = this.getDirection();
        for (int i = 0; i < 4; ++i) {
            int j = verticeSpace * i;
            float oldU = BakedQuadRetexturedAndReUV.getUnInterpolatedU(this.sprite, Float.intBitsToFloat(this.vertices[j + uvIndex]));
            float oldV = BakedQuadRetexturedAndReUV.getUnInterpolatedV(this.sprite, Float.intBitsToFloat(this.vertices[j + uvIndex + 1]));
            switch (direction1) {
                case NORTH: {
                    oldU = 1.0f - Float.intBitsToFloat(this.vertices[j]);
                    oldV = 1.0f - Float.intBitsToFloat(this.vertices[j + 1]);
                    break;
                }
                case WEST: {
                    oldU = Float.intBitsToFloat(this.vertices[j + 2]);
                    oldV = 1.0f - Float.intBitsToFloat(this.vertices[j + 1]);
                    break;
                }
                case SOUTH: {
                    oldU = Float.intBitsToFloat(this.vertices[j]);
                    oldV = 1.0f - Float.intBitsToFloat(this.vertices[j + 1]);
                    break;
                }
                case EAST: {
                    oldU = 1.0f - Float.intBitsToFloat(this.vertices[j + 2]);
                    oldV = 1.0f - Float.intBitsToFloat(this.vertices[j + 1]);
                    break;
                }
                case UP: {
                    oldU = Float.intBitsToFloat(this.vertices[j + 2]);
                    oldV = Float.intBitsToFloat(this.vertices[j]);
                    break;
                }
                case DOWN: {
                    oldU = 0.0f;
                    oldV = 0.0f;
                }
            }
            if (direction1.ordinal() > 1 && this.isSlabDown) {
                oldV -= this.offset;
            }
            oldU = Mth.clamp((float)oldU, (float)0.0f, (float)1.0f);
            oldV = Mth.clamp((float)oldV, (float)0.0f, (float)1.0f);
            this.vertices[j + BakedQuadRetexturedAndReUV.uvIndex] = Float.floatToRawIntBits(this.texture.getU(oldU));
            this.vertices[j + BakedQuadRetexturedAndReUV.uvIndex + 1] = Float.floatToRawIntBits(this.texture.getV(oldV));
        }
    }

    @NotNull
    public TextureAtlasSprite getSprite() {
        return this.texture;
    }

    private static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.getU1() - sprite.getU0();
        return (u - sprite.getU0()) / f;
    }

    private static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.getV1() - sprite.getV0();
        return (v - sprite.getV0()) / f;
    }

    public int getTintIndex() {
        return -1;
    }

    public boolean isTinted() {
        return false;
    }
}

