/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model.bakequad;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class BakedQuadRetexturedLower
extends BakedQuad {
    private final TextureAtlasSprite texture;
    public static int uvIndex = DefaultVertexFormat.BLOCK.getOffset(VertexFormatElement.UV0) / 4;
    public static int verticeSpace = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
    private final boolean isSlabDown;
    private final float offset;

    public BakedQuadRetexturedLower(BakedQuad quad, TextureAtlasSprite textureIn, boolean isSlabDown) {
        this(quad, textureIn, isSlabDown, 0.5f);
    }

    public BakedQuadRetexturedLower(BakedQuad quad, TextureAtlasSprite textureIn, boolean isSlabDown, float offset) {
        super(Arrays.copyOf(quad.getVertices(), quad.getVertices().length), quad.getTintIndex(), FaceBakery.calculateFacing((int[])quad.getVertices()), quad.getSprite(), quad.isShade(), quad.hasAmbientOcclusion());
        this.texture = textureIn;
        this.isSlabDown = isSlabDown;
        this.offset = offset;
        this.remapQuad();
    }

    private void remapQuad() {
        Direction direction1 = this.getDirection();
        for (int i = 0; i < 4; ++i) {
            int j = verticeSpace * i;
            float oldU = BakedQuadRetexturedLower.getUnInterpolatedU(this.sprite, Float.intBitsToFloat(this.vertices[j + uvIndex]));
            float oldV = BakedQuadRetexturedLower.getUnInterpolatedV(this.sprite, Float.intBitsToFloat(this.vertices[j + uvIndex + 1]));
            switch (direction1) {
                case NORTH: {
                    oldU = 1.0f - Float.intBitsToFloat(this.vertices[j]);
                    oldV = 1.0f - Float.intBitsToFloat(this.vertices[j + 1]);
                    break;
                }
                case WEST: {
                    oldU = Float.intBitsToFloat(this.vertices[j + 2]);
                    oldV = 1.0f - Float.intBitsToFloat(this.vertices[j + 1]);
                    break;
                }
                case SOUTH: {
                    oldU = Float.intBitsToFloat(this.vertices[j]);
                    oldV = 1.0f - Float.intBitsToFloat(this.vertices[j + 1]);
                    break;
                }
                case EAST: {
                    oldU = 1.0f - Float.intBitsToFloat(this.vertices[j + 2]);
                    oldV = 1.0f - Float.intBitsToFloat(this.vertices[j + 1]);
                    break;
                }
                case UP: {
                    oldU = Float.intBitsToFloat(this.vertices[j + 2]);
                    oldV = Float.intBitsToFloat(this.vertices[j]);
                    break;
                }
                case DOWN: {
                    oldU = 0.0f;
                    oldV = 0.0f;
                }
            }
            if (direction1.ordinal() > 1 && this.isSlabDown) {
                oldV -= this.offset;
            }
            oldU = Mth.clamp((float)oldU, (float)0.0f, (float)1.0f);
            oldV = Mth.clamp((float)oldV, (float)0.0f, (float)1.0f);
            this.vertices[j + BakedQuadRetexturedLower.uvIndex] = Float.floatToRawIntBits(this.texture.getU(oldU));
            this.vertices[j + BakedQuadRetexturedLower.uvIndex + 1] = Float.floatToRawIntBits(this.texture.getV(oldV));
        }
    }

    @NotNull
    public TextureAtlasSprite getSprite() {
        return this.texture;
    }

    private static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.getU1() - sprite.getU0();
        return (u - sprite.getU0()) / f;
    }

    private static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.getV1() - sprite.getV0();
        return (v - sprite.getV0()) / f;
    }

    public int getTintIndex() {
        return -1;
    }

    public boolean isTinted() {
        return false;
    }
}

