/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model.loader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamtea.eclipticseasons.client.model.SnowyBakedModelWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnowOverlayModel
implements IUnbakedGeometry<SnowOverlayModel> {
    private final BlockModel parentModel;
    private final Map<String, BlockModel> children;
    private final ImmutableList<String> itemPasses;

    @NotNull
    public BakedModel bake(@NotNull IGeometryBakingContext context, @NotNull ModelBaker baker, @NotNull Function<Material, TextureAtlasSprite> spriteGetter, @NotNull ModelState modelState, @NotNull ItemOverrides overrides) {
        return new Baked<BakedModel>(this.parentModel.bake(baker, spriteGetter, modelState));
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.parentModel.resolveParents(modelGetter);
    }

    @NotNull
    public Set<String> getConfigurableComponentNames() {
        return new HashSet<String>((Collection<String>)this.itemPasses);
    }

    @Generated
    public SnowOverlayModel(BlockModel parentModel, Map<String, BlockModel> children, ImmutableList<String> itemPasses) {
        this.parentModel = parentModel;
        this.children = children;
        this.itemPasses = itemPasses;
    }

    @Generated
    public BlockModel getParentModel() {
        return this.parentModel;
    }

    @Generated
    public Map<String, BlockModel> getChildren() {
        return this.children;
    }

    @Generated
    public ImmutableList<String> getItemPasses() {
        return this.itemPasses;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnowOverlayModel)) {
            return false;
        }
        SnowOverlayModel other = (SnowOverlayModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockModel this$parentModel = this.getParentModel();
        BlockModel other$parentModel = other.getParentModel();
        if (this$parentModel == null ? other$parentModel != null : !this$parentModel.equals(other$parentModel)) {
            return false;
        }
        Map<String, BlockModel> this$children = this.getChildren();
        Map<String, BlockModel> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        ImmutableList<String> this$itemPasses = this.getItemPasses();
        ImmutableList<String> other$itemPasses = other.getItemPasses();
        return !(this$itemPasses == null ? other$itemPasses != null : !this$itemPasses.equals(other$itemPasses));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnowOverlayModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockModel $parentModel = this.getParentModel();
        result = result * 59 + ($parentModel == null ? 43 : $parentModel.hashCode());
        Map<String, BlockModel> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        ImmutableList<String> $itemPasses = this.getItemPasses();
        result = result * 59 + ($itemPasses == null ? 43 : $itemPasses.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SnowOverlayModel(parentModel=" + String.valueOf(this.getParentModel()) + ", children=" + String.valueOf(this.getChildren()) + ", itemPasses=" + String.valueOf(this.getItemPasses()) + ")";
    }

    public static class Baked<T extends BakedModel>
    extends SnowyBakedModelWrapper<T> {
        public Baked(T originalModel) {
            super(originalModel);
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            ArrayList quadLists = new ArrayList();
            return ConcatenatedListView.of(quadLists);
        }

        @NotNull
        public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, ModelData modelData) {
            return modelData.derive().build();
        }
    }

    public static final class Loader
    implements IGeometryLoader<SnowOverlayModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public SnowOverlayModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            ArrayList<String> itemPasses = new ArrayList<String>();
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            this.readChildren(jsonObject, "children", deserializationContext, (ImmutableMap.Builder<String, BlockModel>)childrenBuilder, itemPasses);
            JsonObject jsonObject1 = new JsonObject();
            jsonObject1.add("parent", jsonObject.get("parent"));
            JsonElement textures = jsonObject.get("texture_overrides");
            return new SnowOverlayModel(BlockModel.fromString((String)jsonObject1.toString()), (Map<String, BlockModel>)childrenBuilder.build(), (ImmutableList<String>)ImmutableList.copyOf(itemPasses));
        }

        private void readChildren(JsonObject jsonObject, String name, JsonDeserializationContext deserializationContext, ImmutableMap.Builder<String, BlockModel> children, List<String> itemPasses) {
            if (!jsonObject.has(name)) {
                return;
            }
            JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : childrenJsonObject.entrySet()) {
                children.put((Object)((String)entry.getKey()), (Object)((BlockModel)deserializationContext.deserialize((JsonElement)entry.getValue(), BlockModel.class)));
                itemPasses.add((String)entry.getKey());
            }
        }
    }
}

