/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model.unbake;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.client.model.seasonal.SeasonalTexture;
import com.teamtea.eclipticseasons.api.misc.BiomeHolderPredicate;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import com.teamtea.eclipticseasons.client.model.SeasonBiomeGoingModel;
import com.teamtea.eclipticseasons.client.model.SeasonGoingModel;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public class SolarBlockModel
extends BlockModel {
    protected List<SeasonalTexture> seasonalTexture = null;

    public SolarBlockModel(@Nullable ResourceLocation parentLocation, List<BlockElement> elements, Map<String, Either<Material, String>> textureMap, @Nullable Boolean hasAmbientOcclusion, @Nullable BlockModel.GuiLight guiLight, ItemTransforms transforms, List<ItemOverride> overrides) {
        super(parentLocation, elements, textureMap, hasAmbientOcclusion, guiLight, transforms, overrides);
    }

    public static SolarBlockModel of(BlockModel blockModel) {
        SolarBlockModel solarBlockModel = new SolarBlockModel(blockModel.getParentLocation(), blockModel.getElements(), blockModel.textureMap, blockModel.hasAmbientOcclusion(), blockModel.getGuiLight(), blockModel.getTransforms(), blockModel.getOverrides());
        solarBlockModel.customData.copyFrom(blockModel.customData);
        return solarBlockModel;
    }

    public BlockModel to(Map<String, ResourceLocation> stringStringMap, Map<String, Integer> integerMap) {
        HashMap map = new HashMap(this.textureMap);
        if (this.parent != null) {
            map.putAll(this.parent.textureMap);
        }
        stringStringMap.forEach((string, location) -> {
            if (map.containsKey(string)) {
                map.put(string, Either.left((Object)new Material(InventoryMenu.BLOCK_ATLAS, location)));
            }
        });
        ArrayList<BlockElement> elements = this.getElements();
        if (!integerMap.isEmpty()) {
            elements = new ArrayList<BlockElement>(elements);
            int elementsSize = elements.size();
            for (int i = 0; i < elementsSize; ++i) {
                BlockElement element = (BlockElement)elements.get(i);
                Enum2ObjectMap elementFace = new Enum2ObjectMap(Direction.class);
                element.faces.forEach((direction, face) -> {
                    Integer orDefault = integerMap.getOrDefault(face.texture(), null);
                    if (orDefault != null && face.tintIndex() != orDefault.intValue()) {
                        elementFace.put((Direction)direction, new BlockElementFace(face.cullForDirection(), orDefault.intValue(), face.texture(), face.uv(), face.faceData(), face.parent()));
                    } else {
                        elementFace.put((Direction)direction, face);
                    }
                });
                BlockElement blockElement = new BlockElement(element.from, element.to, elementFace, element.rotation, element.shade, element.getFaceData());
                elements.set(i, blockElement);
            }
        }
        return new BlockModel(this.getParentLocation(), elements, map, Boolean.valueOf(this.hasAmbientOcclusion()), this.getGuiLight(), this.getTransforms(), this.getOverrides());
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> resolver) {
        super.resolveParents(resolver);
    }

    public List<BlockModel> toList(List<Map<String, ResourceLocation>> stringStringMap, Map<String, Integer> stringIntegerMap) {
        return stringStringMap.stream().map(m -> this.to((Map<String, ResourceLocation>)m, stringIntegerMap)).toList();
    }

    public List<Pair<BlockModel, BlockModel>> toPairList(List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> stringStringMap, Map<String, Integer> stringIntegerMap) {
        return stringStringMap.stream().map(p -> Pair.of((Object)this.to((Map)p.getFirst(), stringIntegerMap), (Object)this.to((Map)p.getSecond(), stringIntegerMap))).toList();
    }

    public SolarBlockModel setSeasonalTexture(List<SeasonalTexture> seasonalTexture) {
        this.seasonalTexture = seasonalTexture;
        return this;
    }

    public BakedModel bake(ModelBaker baker, BlockModel model, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state, boolean guiLight3d) {
        if (this.seasonalTexture != null) {
            BakedModel bake = UnbakedGeometryHelper.bake((BlockModel)this, (ModelBaker)baker, (BlockModel)model, spriteGetter, (ModelState)state, (boolean)guiLight3d);
            SeasonGoingModel<BakedModel> end = null;
            ArrayList list = new ArrayList();
            ArrayList<Pair> defaultList = new ArrayList<Pair>();
            Object2ObjectOpenCustomHashMap bakedCache = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<BlockModel>(this){

                public int hashCode(BlockModel blockModel) {
                    return Objects.hash(blockModel.getElements(), blockModel.textureMap);
                }

                public boolean equals(BlockModel a, BlockModel b) {
                    if (a == b) {
                        return true;
                    }
                    if (b == null || a.getClass() != b.getClass()) {
                        return false;
                    }
                    return a.getElements().equals(b.getElements()) && a.textureMap.equals(b.textureMap);
                }
            });
            for (SeasonalTexture texture : this.seasonalTexture) {
                Enum2ObjectMap solarTermBakedModelEnumMap = new Enum2ObjectMap(SolarTerm.class);
                Enum2ObjectMap snowSolarTermBakedModelEnumMap = new Enum2ObjectMap(SolarTerm.class);
                texture.getFlatSliceEnumMap().forEach((arg_0, arg_1) -> this.lambda$bake$14(solarTermBakedModelEnumMap, (Map)bakedCache, baker, model, spriteGetter, state, guiLight3d, snowSolarTermBakedModelEnumMap, arg_0, arg_1));
                end = new SeasonGoingModel<BakedModel>(bake, solarTermBakedModelEnumMap, snowSolarTermBakedModelEnumMap);
                if (texture.getBiomes().isEmpty()) {
                    defaultList.add(Pair.of(b -> true, end));
                    continue;
                }
                BiomeHolderPredicate biomePredicate = biomeHolder -> {
                    Optional biomeResourceKey;
                    Optional<Either<List<ResourceLocation>, TagKey<Biome>>> biomes = texture.getBiomes();
                    if (biomes.isEmpty()) {
                        return true;
                    }
                    Either<List<ResourceLocation>, TagKey<Biome>> either = biomes.get();
                    if (either.left().isPresent() && (biomeResourceKey = biomeHolder.unwrapKey()).isPresent()) {
                        return ((List)either.left().get()).contains(((ResourceKey)biomeResourceKey.get()).location());
                    }
                    if (either.right().isPresent()) {
                        return biomeHolder.is((TagKey)either.right().get());
                    }
                    return true;
                };
                list.add(Pair.of((Object)biomePredicate, end));
            }
            if (end != null) {
                if (list.size() == 1 && ((Pair)list.get(0)).getFirst() == null) {
                    return end;
                }
                if (!defaultList.isEmpty()) {
                    list.add((Pair)defaultList.get(defaultList.size() - 1));
                }
                return new SeasonBiomeGoingModel<BakedModel>(bake, list);
            }
        }
        return super.bake(baker, model, spriteGetter, state, guiLight3d);
    }

    private /* synthetic */ void lambda$bake$14(Enum2ObjectMap solarTermBakedModelEnumMap, Map bakedCache, ModelBaker baker, BlockModel model, Function spriteGetter, ModelState state, boolean guiLight3d, Enum2ObjectMap snowSolarTermBakedModelEnumMap, SolarTerm solarTerm, SeasonalTexture.FlatSliceHolder flatSliceHolders) {
        if (flatSliceHolders.flatSlice().mid() != null) {
            solarTermBakedModelEnumMap.put(solarTerm, this.toList(flatSliceHolders.flatSlice().mid(), flatSliceHolders.flatSlice().tintMap()).stream().map(b -> {
                BakedModel sliceModel = bakedCache.computeIfAbsent(b, blockModel -> UnbakedGeometryHelper.bake((BlockModel)b, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (boolean)guiLight3d));
                return Pair.of((Object)sliceModel, (Object)sliceModel);
            }).toList());
        }
        if (flatSliceHolders.flatSlice().transitionModels() != null) {
            solarTermBakedModelEnumMap.put(solarTerm, this.toPairList(flatSliceHolders.flatSlice().transitionModels(), flatSliceHolders.flatSlice().tintMap()).stream().map(b -> Pair.of((Object)bakedCache.computeIfAbsent((BlockModel)b.getFirst(), blockModel -> UnbakedGeometryHelper.bake((BlockModel)blockModel, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (boolean)guiLight3d)), (Object)bakedCache.computeIfAbsent((BlockModel)b.getSecond(), blockModel -> UnbakedGeometryHelper.bake((BlockModel)blockModel, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (boolean)guiLight3d)))).toList());
        }
        if (flatSliceHolders.snowSlice().mid() != null) {
            snowSolarTermBakedModelEnumMap.put(solarTerm, this.toList(flatSliceHolders.snowSlice().mid(), flatSliceHolders.snowSlice().tintMap()).stream().map(b -> {
                BakedModel sliceModel = bakedCache.computeIfAbsent(b, blockModel -> UnbakedGeometryHelper.bake((BlockModel)b, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (boolean)guiLight3d));
                return Pair.of((Object)sliceModel, (Object)sliceModel);
            }).toList());
        }
        if (flatSliceHolders.snowSlice().transitionModels() != null) {
            snowSolarTermBakedModelEnumMap.put(solarTerm, this.toPairList(flatSliceHolders.snowSlice().transitionModels(), flatSliceHolders.snowSlice().tintMap()).stream().map(b -> Pair.of((Object)bakedCache.computeIfAbsent((BlockModel)b.getFirst(), blockModel -> UnbakedGeometryHelper.bake((BlockModel)blockModel, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (boolean)guiLight3d)), (Object)bakedCache.computeIfAbsent((BlockModel)b.getSecond(), blockModel -> UnbakedGeometryHelper.bake((BlockModel)blockModel, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (boolean)guiLight3d)))).toList());
        }
    }
}

