/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamtea.eclipticseasons.client.particle.FireflyParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class ButterflyParticle
extends FireflyParticle {
    private final SpriteSet spriteSet;
    private boolean isBlink;
    private Vec3 nextPos;

    public ButterflyParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z, spriteSet);
        this.lifetime = 800;
        this.gravity = 1.0E-4f;
        this.spriteSet = spriteSet;
        this.isBlink = false;
        this.setSprite(spriteSet.get(level.getRandom()));
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    protected void renderRotatedQuad(VertexConsumer pBuffer, Quaternionf pQuaternion, float pX, float pY, float pZ, float pPartialTicks) {
        float f = this.getQuadSize(pPartialTicks);
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int i = this.getLightColor(pPartialTicks);
        float ff = System.currentTimeMillis() % 4000L;
        ff = 1.0f - Math.abs((ff - 2000.0f) / 2000.0f);
        float pXOffset1 = 1.0f;
        float pXOffset0 = -1.0f;
        float pYOffset1 = 1.0f;
        float pYOffset0 = -1.0f;
        boolean revex = true;
        if (Minecraft.getInstance().getCameraEntity() != null) {
            Vec3 viewVec = Minecraft.getInstance().getCameraEntity().getLookAngle();
            double vx = viewVec.x;
            double vz = viewVec.z;
            double crossY = vx * this.zd - vz * this.xd;
            if (crossY < (double)0.01f) {
                float ut = u0;
                u0 = u1;
                u1 = ut;
                revex = false;
            }
        }
        pQuaternion = revex ? pQuaternion.rotateAxis(ff * 70.0f * ((float)Math.PI / 180), 1.0f, 1.0f, 0.0f) : pQuaternion.rotateAxis(ff * 70.0f * ((float)Math.PI / 180), -1.0f, 1.0f, 0.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, pXOffset1, pYOffset0, f, u1, v1, i, 1.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, pXOffset1, pYOffset1, f, u1, v0, i, 1.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, pXOffset0, pYOffset1, f, u0, v0, i, 1.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, pXOffset0, pYOffset0, f, u0, v1, i, 1.0f);
        pQuaternion = revex ? pQuaternion.rotateAxis(ff * -140.0f * ((float)Math.PI / 180), 1.0f, 1.0f, 0.0f) : pQuaternion.rotateAxis(ff * -140.0f * ((float)Math.PI / 180), -1.0f, 1.0f, 0.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, pXOffset1, pYOffset0, f, u1, v1, i, 1.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, pXOffset1, pYOffset1, f, u1, v0, i, 1.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, pXOffset0, pYOffset1, f, u0, v0, i, 1.0f);
        this.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, pXOffset0, pYOffset0, f, u0, v1, i, 1.0f);
    }

    @Override
    protected void renderVertex(VertexConsumer pBuffer, Quaternionf pQuaternion, float pX, float pY, float pZ, float pXOffset, float pYOffset, float pQuadSize, float pU, float pV, int pPackedLight, float alpha) {
        super.renderVertex(pBuffer, pQuaternion, pX, pY, pZ, pXOffset, pYOffset, pQuadSize, pU, pV, pPackedLight, alpha);
    }

    @Override
    public void tick() {
        super.tick();
    }
}

