/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.RisingParticle;
import net.minecraft.client.particle.SpriteSet;

public class WildGooseParticle
extends RisingParticle {
    private final SpriteSet spriteSet;

    public WildGooseParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.spriteSet = spriteSet;
        this.scale(2.8f);
        this.lifetime = 200;
        this.hasPhysics = true;
        this.gravity = 1.0E-4f;
        this.alpha = 1.0f;
        this.setSpriteFromAge(spriteSet);
        this.setParticleSpeed(0.0, 0.0, 0.0);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        if (this.level.getNearestPlayer(this.x + this.xd, this.y + this.yd, this.z + this.zd, 16.0, false) != null) {
            this.age = this.lifetime + 1;
        }
        super.tick();
        try {
            this.setSprite(this.spriteSet.get(this.age % 27 / 3, 8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.move(0.1f, 0.01f, 0.1f);
    }
}

