/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.render;

import com.mojang.blaze3d.shaders.Uniform;
import com.teamtea.eclipticseasons.client.ClientEventHandler;
import com.teamtea.eclipticseasons.common.registry.EffectRegistry;
import com.teamtea.eclipticseasons.config.CommonConfig;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.FogType;
import net.neoforged.neoforge.client.event.ViewportEvent;

public class WorldRenderer {
    public static long reMainTick = 0L;
    public static final int NONE_BLUR = 1;
    public static final int ON_BLUR = 2;
    public static final int TO_BLUR = 3;
    public static final int CLEAR_BLUR = 3;
    public static int oldBlurStatus = 1;

    private static float getProgress(boolean fadeIn) {
        return Math.min(fadeIn ? 1.0f - (float)reMainTick / 100.0f : (float)reMainTick / 100.0f, 1.0f);
    }

    public static void applyEffect(GameRenderer gameRenderer, LocalPlayer player) {
        if (player == null) {
            return;
        }
        if (Minecraft.getInstance().isPaused()) {
            if (oldBlurStatus == 2 || reMainTick > 0L) {
                gameRenderer.shutdownEffect();
                oldBlurStatus = 1;
                reMainTick = 0L;
                WorldRenderer.updateUniform("RadiusMultiplier", 0.0f);
            }
            return;
        }
        if (((Boolean)CommonConfig.Temperature.heatStroke.get()).booleanValue()) {
            int blurStatus;
            boolean hasEffect = false;
            for (Holder activeEffect : player.getActiveEffectsMap().keySet()) {
                if (!activeEffect.is(EffectRegistry.Effects.HEAT_STROKE)) continue;
                hasEffect = true;
                break;
            }
            int n = blurStatus = hasEffect ? 2 : 1;
            if (blurStatus != oldBlurStatus) {
                if (blurStatus == 2) {
                    gameRenderer.loadEffect(ResourceLocation.withDefaultNamespace((String)"shaders/post/blur.json"));
                }
                reMainTick = reMainTick > 0L ? (reMainTick -= 10L) : 100L;
                float progress = WorldRenderer.getProgress(blurStatus == 2) * 0.03f;
                WorldRenderer.updateUniform("RadiusMultiplier", progress *= 10.0f);
                if (reMainTick <= 0L) {
                    oldBlurStatus = blurStatus;
                    if (oldBlurStatus == 1) {
                        gameRenderer.shutdownEffect();
                    }
                    reMainTick = 0L;
                }
            }
        }
    }

    public static void updateUniform(String name, float value) {
        PostChain postChain = Minecraft.getInstance().gameRenderer.currentEffect();
        if (postChain != null) {
            for (PostPass postPass : postChain.passes) {
                Uniform uniform = postPass.getEffect().getUniform(name);
                if (uniform == null) continue;
                uniform.set(value);
            }
        }
    }

    public static void renderFogColors(Camera camera, float partialTick, ViewportEvent.ComputeFogColor event) {
        Entity entity = camera.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (camera.getFluidInCamera() == FogType.NONE && ClientEventHandler.prevFogDensity > 0.0f) {
                float angle = player.level().getSunAngle(partialTick);
                float height = Mth.cos((float)angle);
                float delta = Mth.clamp((float)((height + 0.4f) / 0.8f), (float)0.0f, (float)1.0f);
                int colorDay = 12566488;
                int colorNight = 789529;
                float red = 191.0f * delta + 12.0f * (1.0f - delta);
                float green = 191.0f * delta + 12.0f * (1.0f - delta);
                float blue = 216.0f * delta + 25.0f * (1.0f - delta);
                event.setRed(red / 255.0f);
                event.setBlue(blue / 255.0f);
                event.setGreen(green / 255.0f);
                ClientEventHandler.r = red / 255.0f;
                ClientEventHandler.g = blue / 255.0f;
                ClientEventHandler.b = green / 255.0f;
            }
        }
    }

    public static void renderFogDensity(Camera camera, ViewportEvent.RenderFog event) {
        Entity entity = camera.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            long thisTick = Util.getMillis();
            boolean firstTick = ClientEventHandler.prevFogTick == -1L;
            float deltaTick = firstTick ? 1.0E10f : (float)(thisTick - ClientEventHandler.prevFogTick) * 1.5E-4f;
            ClientEventHandler.prevFogTick = thisTick;
            float expectedFogDensity = 0.0f;
            Level level = player.level();
            Biome biome = (Biome)level.getBiome(camera.getBlockPosition()).value();
            if (level.isRaining() && biome.coldEnoughToSnow(camera.getBlockPosition())) {
                int light = level.getBrightness(LightLayer.SKY, BlockPos.containing((Position)player.getEyePosition()));
                expectedFogDensity = Mth.clampedMap((float)light, (float)0.0f, (float)15.0f, (float)0.0f, (float)1.0f);
            }
            if (expectedFogDensity > ClientEventHandler.prevFogDensity) {
                ClientEventHandler.prevFogDensity = Math.min(ClientEventHandler.prevFogDensity + 4.0f * deltaTick, expectedFogDensity);
            } else if (expectedFogDensity < ClientEventHandler.prevFogDensity) {
                ClientEventHandler.prevFogDensity = Math.max(ClientEventHandler.prevFogDensity - deltaTick, expectedFogDensity);
            }
            if (camera.getFluidInCamera() != FogType.NONE) {
                ClientEventHandler.prevFogDensity = -1.0f;
                ClientEventHandler.prevFogTick = -1L;
            }
            if (ClientEventHandler.prevFogDensity > 0.0f) {
                float scaledDelta = 1.0f - (1.0f - ClientEventHandler.prevFogDensity) * (1.0f - ClientEventHandler.prevFogDensity);
                float fogDensity = 0.1f;
                float farPlaneScale = Mth.lerp((float)scaledDelta, (float)1.0f, (float)0.1f);
                float nearPlaneScale = Mth.lerp((float)scaledDelta, (float)1.0f, (float)0.030000001f);
                event.scaleNearPlaneDistance(nearPlaneScale);
                event.scaleFarPlaneDistance(farPlaneScale);
                event.setCanceled(true);
            }
        }
    }

    public static boolean isSectionLoad(SectionPos sectionPos) {
        return WorldRenderer.isSectionLoad(sectionPos, 1);
    }

    public static boolean isSectionLoad(SectionPos pPos, int range) {
        boolean load = true;
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel instanceof Level) {
            ClientLevel level = clientLevel;
            for (int i = -range + 1; i < range; ++i) {
                for (int j = -range + 1; j < range && (load &= level.getChunk(pPos.getX() + i, pPos.getZ() + j, ChunkStatus.FULL, false) != null); ++j) {
                }
            }
        }
        return load;
    }

    public static void setSectionDirty(SectionPos sectionPos) {
        if (WorldRenderer.isSectionLoad(sectionPos)) {
            Minecraft.getInstance().levelRenderer.setSectionDirty(sectionPos.x(), sectionPos.y(), sectionPos.z());
        }
    }

    public static void setSectionDirtyWithNeighbors(SectionPos sectionPos) {
        if (WorldRenderer.isSectionLoad(sectionPos, 2)) {
            Minecraft.getInstance().levelRenderer.setSectionDirtyWithNeighbors(sectionPos.x(), sectionPos.y(), sectionPos.z());
        }
    }

    public static void setSectionDirtyRandomly(SectionPos sectionPos) {
        if (Minecraft.getInstance().level != null) {
            RandomSource random = Minecraft.getInstance().level.random;
            int lastViewDistance = (int)(Minecraft.getInstance().levelRenderer.getLastViewDistance() - 1.0);
            for (int i = 0; i < random.nextInt(8) + 4; ++i) {
                WorldRenderer.setSectionDirtyWithNeighbors(SectionPos.of((int)(sectionPos.x() + 2 * random.nextInt(lastViewDistance) - lastViewDistance), (int)sectionPos.y(), (int)(sectionPos.z() + 2 * random.nextInt(lastViewDistance) - lastViewDistance)));
            }
        }
    }

    public static void setAllDirty(SectionPos centerPos) {
        int pSectionX = centerPos.x();
        int pSectionY = centerPos.y();
        int pSectionZ = centerPos.z();
        int d = (int)Minecraft.getInstance().levelRenderer.getLastViewDistance();
        for (int j = pSectionZ - d; j <= pSectionZ + d; ++j) {
            for (int i = pSectionX - d; i <= pSectionX + d; ++i) {
                for (int k = pSectionY - 3; k <= pSectionY + 1; ++k) {
                    WorldRenderer.setSectionDirty(SectionPos.of((int)i, (int)k, (int)j));
                }
            }
        }
    }
}

