/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamtea.eclipticseasons.client.render.TryModel;
import com.teamtea.eclipticseasons.client.render.item.GreenHouseCoreItemRenderer;
import com.teamtea.eclipticseasons.common.block.GreenHouseCoreBlock;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class GreenHouseCoreCoreItemRenderer
extends GreenHouseCoreItemRenderer {
    public GreenHouseCoreCoreItemRenderer(BlockEntityRenderDispatcher renderDispatcher, EntityModelSet modelSet) {
        super(renderDispatcher, modelSet);
        this.modelPart = TryModel.createCoreLayer().bakeRoot().getChild("All");
    }

    @Override
    protected PoseStack rotateMatrix(PoseStack matrixStackIn, ItemDisplayContext transformType) {
        if (transformType == ItemDisplayContext.GUI) {
            matrixStackIn.translate(0.0f, 0.375f, 0.0f);
        } else if (transformType == ItemDisplayContext.GROUND) {
            matrixStackIn.translate(0.0f, 0.375f, 0.0f);
        } else if (transformType == ItemDisplayContext.FIXED) {
            matrixStackIn.translate(0.0f, 0.5f, -0.25f);
        } else if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            matrixStackIn.translate(0.0, 0.75, 0.0);
        } else if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            matrixStackIn.translate(0.0, 0.75, 0.0);
        } else if (transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            matrixStackIn.translate(0.75, 0.0, -0.75);
        } else if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            matrixStackIn.translate(-0.75, 0.0, -0.75);
        }
        return matrixStackIn;
    }

    @Override
    protected void doAnimate(ModelPart modelPart1, long renderTicks, ItemDisplayContext context) {
        if (context == ItemDisplayContext.GROUND) {
            modelPart1.xScale = 1.0f;
            modelPart1.yScale = 1.0f;
            modelPart1.zScale = 1.0f;
        } else {
            modelPart1.offsetScale(new Vector3f(0.5f, 0.5f, 0.5f));
        }
        modelPart1.y += 0.25f;
        modelPart1.x += 0.75f;
    }

    @Override
    protected int getLightFromItem(ItemStack stack) {
        return TryModel.getLightFromBlock(this.getGreenHouseCoreBlockFromItem(stack));
    }

    @Override
    protected Material getMaterialFromItem(ItemStack stack) {
        return TryModel.getMaterialFromBlock(this.getGreenHouseCoreBlockFromItem(stack));
    }

    private GreenHouseCoreBlock getGreenHouseCoreBlockFromItem(ItemStack stack) {
        if (stack.getItem() == ItemRegistry.summer_greenhouse_essence_item.get()) {
            return (GreenHouseCoreBlock)((Object)BlockRegistry.summer_greenhouse_core.get());
        }
        if (stack.getItem() == ItemRegistry.winter_greenhouse_essence_item.get()) {
            return (GreenHouseCoreBlock)((Object)BlockRegistry.winter_greenhouse_core.get());
        }
        if (stack.getItem() == ItemRegistry.autumn_greenhouse_essence_item.get()) {
            return (GreenHouseCoreBlock)((Object)BlockRegistry.autumn_greenhouse_core.get());
        }
        return (GreenHouseCoreBlock)((Object)BlockRegistry.spring_greenhouse_core.get());
    }
}

