/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.sound;

import java.lang.ref.WeakReference;
import java.util.Set;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class LoopSeasonalSoundInstance
extends AbstractTickableSoundInstance {
    private final WeakReference<Set<LoopSeasonalSoundInstance>> loopSounds;
    private int fadeDirection;
    private int fade;
    private long lastTickTime;

    public LoopSeasonalSoundInstance(SoundEvent soundEvent, Set<LoopSeasonalSoundInstance> loopSounds) {
        super(soundEvent, SoundSource.AMBIENT, SoundInstance.createUnseededRandom());
        this.looping = true;
        this.delay = 0;
        this.volume = 0.5f;
        this.relative = true;
        this.lastTickTime = System.currentTimeMillis();
        this.loopSounds = new WeakReference<Set<LoopSeasonalSoundInstance>>(loopSounds);
    }

    public void tick() {
        if (this.isStopped()) {
            return;
        }
        Set loopSeasonalSoundInstances = (Set)this.loopSounds.get();
        if (loopSeasonalSoundInstances != null && !loopSeasonalSoundInstances.contains((Object)this)) {
            this.fadeDirection = -1;
        }
        if (this.fade < 0) {
            this.stop();
            this.fadeDirection = 0;
        }
        this.fade += this.fadeDirection;
        this.volume = Mth.clamp((float)((float)this.fade / 40.0f), (float)0.0f, (float)1.0f);
        this.lastTickTime = System.currentTimeMillis();
    }

    public void fadeOut() {
        this.fade = Math.min(this.fade, 40);
        this.fadeDirection = -1;
        this.checkIfForceStop();
    }

    public void fadeIn() {
        this.fade = Math.max(0, this.fade);
        this.fadeDirection = this.fade < 40 ? 1 : 0;
        this.checkIfForceStop();
    }

    public void checkIfForceStop() {
        if (this.lastTickTime - System.currentTimeMillis() > 5000L) {
            this.stop();
        }
    }
}

