/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.sound;

import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.common.registry.SoundEventsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.Tags;

public class SoundControllers {
    public static final List<SoundEvent> EMPTY = new ArrayList<SoundEvent>();

    public static class SpringSoundController
    implements ISoundController {
        @Override
        public boolean isValidInSolarTerm(SolarTerm solarTerm) {
            return solarTerm.getSeason() == Season.SPRING;
        }

        @Override
        public List<SoundEvent> getSoundEvents(Level level, Player player, Holder<Biome> biome, SolarTerm solarTerm, boolean isDay, boolean inDoor) {
            if (solarTerm.getSeason() == Season.SPRING && player.isInWaterOrRain() && (biome.is(Biomes.CHERRY_GROVE) || biome.is(BiomeTags.IS_FOREST) || biome.is(Tags.Biomes.IS_PLAINS)) && !biome.is(Tags.Biomes.IS_COLD)) {
                return Stream.of(SoundEventsRegistry.spring_forest).toList();
            }
            return EMPTY;
        }
    }

    public static interface ISoundController {
        default public boolean isValidIndoor() {
            return false;
        }

        default public boolean isValidInDay() {
            return true;
        }

        public boolean isValidInSolarTerm(SolarTerm var1);

        default public boolean isValidTime(SolarTerm solarTerm, boolean isDay, boolean inDoor) {
            return inDoor == this.isValidIndoor() && isDay == this.isValidInDay() && this.isValidInSolarTerm(solarTerm);
        }

        public List<SoundEvent> getSoundEvents(Level var1, Player var2, Holder<Biome> var3, SolarTerm var4, boolean var5, boolean var6);
    }
}

