/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.common.registry.ModAdvancements;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class ParentNeedCriterion
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player) {
        MinecraftServer server = player.getServer();
        if (server != null) {
            this.trigger(player, t -> t.test(player, server.getAdvancements()));
        }
    }

    public static final class TriggerInstance
    implements SimpleCriterionTrigger.SimpleInstance {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.optionalFieldOf("parent").forGetter(TriggerInstance::parent)).apply((Applicative)builder, TriggerInstance::new));
        private final Optional<ResourceLocation> parent;
        private WeakReference<AdvancementHolder> advancementHolderWeakReference = new WeakReference<Object>(null);

        public TriggerInstance(Optional<ResourceLocation> parent) {
            this.parent = parent;
        }

        public static Criterion<TriggerInstance> simple(AdvancementHolder advancementHolder) {
            return ModAdvancements.parentNeedCriterion.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.of(advancementHolder.id())));
        }

        public static Criterion<TriggerInstance> simple(ResourceLocation resourceLocation) {
            return ModAdvancements.parentNeedCriterion.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.of(resourceLocation)));
        }

        public boolean test(ServerPlayer player, ServerAdvancementManager advancements) {
            if (this.parent.isEmpty()) {
                return true;
            }
            AdvancementHolder advancementHolder = (AdvancementHolder)this.advancementHolderWeakReference.get();
            if (advancementHolder == null) {
                advancementHolder = advancements.get(this.parent.get());
                this.advancementHolderWeakReference = new WeakReference<AdvancementHolder>(advancementHolder);
            }
            if (advancementHolder == null) {
                return true;
            }
            return player.getAdvancements().getOrStartProgress(advancementHolder).isDone();
        }

        @NotNull
        public Optional<ContextAwarePredicate> player() {
            return Optional.empty();
        }

        public Optional<ResourceLocation> parent() {
            return this.parent;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TriggerInstance that = (TriggerInstance)obj;
            return Objects.equals(this.parent, that.parent);
        }

        public int hashCode() {
            return Objects.hash(this.parent);
        }

        public String toString() {
            return "TriggerInstance[parent=" + String.valueOf(this.parent) + "]";
        }
    }
}

